% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/kfunc.R
\name{kfunc}
\alias{kfunc}
\title{estimate Ripley's K function}
\usage{
kfunc(x, d = seq(0, 100, by = 0.1), lengths, exclude = 0, tol = 0.000001)
}
\arguments{
\item{x}{list with sorted locations of the data}

\item{d}{values at which to calculate the function}

\item{lengths}{lengths of segments studied}

\item{exclude}{distance to exclude}

\item{tol}{tolerance value}
}
\value{
data frame with \code{d}, \code{k}, and \code{se}
}
\description{
estimate the 1-d version of Ripley's K function
}
\examples{
L <- 103
n <- 2000
map1 <- sim.map(L, n.mar=104, anchor=TRUE, include.x=FALSE, eq=TRUE)
x <- sim.cross(map1, n.ind=n, m=6, type="bc")

xoloc <- find.breaks(x)

d <- seq(0, 100, by=0.1)[-1]
kf <- kfunc(xoloc, d=d, lengths=rep(L, n))

plot(k ~ d, data=kf, type="n", yaxs="i", xaxs="i", las=1,
     ylim=c(0, max(kf$k + kf$se)))
polygon(c(kf$d, rev(kf$d)), c(kf$k + kf$se, rev(kf$k-kf$se)),
        border=NA, col="#add8e650")
lines(k ~ d, data=kf)
}
\seealso{
\code{\link{gammacoi}}, \code{\link{stahlcoi}}, \code{\link{coincidence}}
}
\keyword{models}

