\name{gammacoi}
\alias{gammacoi}

\title{Coincidence function for the gamma model}

\description{
  Calculates the coincidence function for the gamma model.
}

\usage{
gammacoi(nu, L=103, x, n=400, max.conv=25)
}
\arguments{
 \item{nu}{The interference parameter in the gamma model.}
\item{L}{Maximal distance (in cM) at which to calculate the
  density. Ignored if \code{x} is specified.}
\item{x}{If specified, points at which to calculate the density.}
\item{n}{Number of points at which to calculate the density.  The points
  will be evenly distributed between 0 and \code{L}. Ignored if \code{x}
  is specified.}
\item{max.conv}{Maximum limit for summation in the convolution.  This
  should be greater than the maximum number of chiasmata on the 4-strand
  bundle.}
}

\value{
  A data frame with two columns: \code{x} is the distance (between 0
  and \code{L}, in cM) at which the coicidence was calculated and
  \code{coincidence}.
}

\details{
  Let \eqn{f(x;\nu)}{f(x;nu)} denote the density of a gamma random
  variable with parameters shape=\eqn{\nu}{nu} and rate=\eqn{2\nu}{2
    nu}, and let \eqn{f_k(x;\nu)}{f_k(x;nu)} denote the density of a gamma random
  variable with parameters shape=\eqn{k \nu}{k nu} and rate=\eqn{2\nu}{2
    nu}.  

  The coincidence function for the gamma model is
  \eqn{C(x;\nu) = \sum_{k=1}^{\infty} f_k(x;\nu)/2}{C(x;nu) = sum_(k=1 to infty)
    f_k(x;nu)/2}.
}

\references{
  Broman,  K. W. and Weber, J. L. (2000) Characterization of human
  crossover interference. \emph{Am. J. Hum. Genet.} \bold{66},
  1911--1926. 

  Broman, K. W., Rowe, L. B., Churchill, G. A. and Paigen, K. (2002)
  Crossover interference in the mouse. \emph{Genetics} \bold{160}, 1123--1131.

  McPeek, M. S. and Speed, T. P. (1995) Modeling interference in genetic
  recombination.  \emph{Genetics} \bold{139}, 1031--1044.
}

\author{Karl W Broman, \email{kbroman@biostat.wisc.edu}}

\examples{
f1 <- gammacoi(1, L=200)
plot(f1, type="l", lwd=2, las=1,
     ylim=c(0,1.25), yaxs="i", xaxs="i", xlim=c(0,200))

f2 <- gammacoi(2.6, L=200)
lines(f2, col="blue", lwd=2)

f3 <- gammacoi(4.3, L=200)
lines(f3, col="red", lwd=2)

f4 <- gammacoi(7.6, L=200)
lines(f4, col="green", lwd=2)
}

\seealso{ \code{\link{stahlcoi}}, \code{\link{location.given.one}},
    \code{\link{first.given.two}},
      \code{\link{distance.given.two}},
\code{\link{joint.given.two}},	\code{\link{ioden}},
	\code{\link{firstden}},
	\code{\link{xoprob}} } 

\keyword{distribution}
