% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOffers_Account.R
\name{getOffers_Account}
\alias{getOffers_Account}
\title{Get an overview of offers on the Stellar ledger.}
\usage{
getOffers_Account(pk, cursor = NULL, limit = 10, order = "asc",
  data.table = TRUE, domain = "public")
}
\arguments{
\item{pk}{character - your Stellar account/wallet address.}

\item{cursor}{numeric - optional, a paging token - where to start from. Can also be "now".}

\item{limit}{numeric - optional, the number of records to return.}

\item{order}{character - optional, "asc" or "desc"}

\item{data.table}{boolean - if TRUE, a data.table is returned. If FALSE or NULL, a list is returned.}

\item{domain}{character - signalling to query the testnet or public network. Can be either "testnet" or "public".}
}
\value{
list
}
\description{
Returns offers with a particular account. Converts the JSON response to a list.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/offers-for-account.html
}
\examples{
\donttest{getOperations_Account("GCO2IP3MJNUOKS4PUDI4C7LGGMQDJGXG3COYX3WSB4HHNAHKYV5YL3VC")}
}
