% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_utf8}
\alias{read_utf8}
\alias{write_utf8}
\title{Read / write files encoded in UTF-8}
\usage{
read_utf8(con)

write_utf8(text, con, ...)
}
\arguments{
\item{con}{A connection or a file path.}

\item{text}{A character vector (will be converted to UTF-8 via
\code{\link{enc2utf8}()}).}

\item{...}{Other arguments passed to \code{\link{writeLines}()} (except
\code{useBytes}, which is \code{TRUE} in \code{write_utf8()}).}
}
\description{
Read or write files, assuming they are encoded in UTF-8. \code{read_utf8()}
is roughly \code{readLines(encoding = 'UTF-8')} (a warning will be issued if
non-UTF8 lines are found), and \code{write_utf8()} calls
\code{writeLines(enc2utf8(text), useBytes = TRUE)}.
}
