% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaPopulation.R
\name{xegaBestInPopulation}
\alias{xegaBestInPopulation}
\title{Best solution in the population.}
\usage{
xegaBestInPopulation(pop, fit, lF, allsolutions = FALSE)
}
\arguments{
\item{pop}{Population of genes.}

\item{fit}{Vector of fitness values of \code{pop}.}

\item{lF}{Local function configuration.}

\item{allsolutions}{If TRUE, also return a list of all solutions.}
}
\value{
Named list with the following elements:
    \itemize{
        \item \code{$name}:     The name of the problem environment.
        \item \code{$fitness}:  The fitness value of the best solution.
        \item \code{$value}:      The evaluated best gene. 
        \item \code{$numberOfSolutions}:   The number of solutions.
        \item \code{$genotype}:    The best gene.
        \item \code{$phenotype}:   The parameters of the solution
                           (the decoded gene).
        \item \code{$phenotypeValue}:  The value of the
                           function of the parameters of the solution
                           (the decoded gene).
        \item \code{$allgenotypes}:  The genotypes of all best solutions.
                                  (allsolutions==TRUE)
        \item \code{$allphenotypes}:  The phenotypes of all best solutions.
                                  (allsolutions==TRUE)
    }
}
\description{
\code{xegaBestInPopulation()} extracts the best
             individual of a population and
             reports fitness, value, genotype, and phenotype:

             \enumerate{
             \item
             \code{fitness}:  The fitness value of the genetic algorithm.
             \item
             \code{value}:   The function value of the problem environment.
             \item
             \code{genotype}:  The gene representation.
             \item  
             \code{phenotype}: The problem representation.
                E.g. a parameter list, a program, ...
             }

             We report one of the best solutions.
}
\examples{
pop10<-xegaInitPopulation(10, lFxegaGaGene)
epop10<-xegaEvalPopulation(pop10, lFxegaGaGene)
xegaBestInPopulation(epop10$pop, epop10$fit, lFxegaGaGene)

}
\seealso{
Other Population Layer: 
\code{\link{xegaBestGeneInPopulation}()},
\code{\link{xegaEvalPopulation}()},
\code{\link{xegaInitPopulation}()},
\code{\link{xegaLogEvalsPopulation}()},
\code{\link{xegaNextPopulation}()},
\code{\link{xegaObservePopulation}()},
\code{\link{xegaRepEvalPopulation}()},
\code{\link{xegaSummaryPopulation}()}
}
\concept{Population Layer}
