% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaNextPopulation.R
\name{xegaEvalPopulation}
\alias{xegaEvalPopulation}
\title{Evaluates a population of genes in a a problem environment}
\usage{
xegaEvalPopulation(pop, lF)
}
\arguments{
\item{pop}{Population of genes.}

\item{lF}{Local function configuration.}
}
\value{
List of fitness values.
}
\description{
\code{EvalPopulation()} evaluates a population
                 of genes in a problem environment.
}
\details{
Parallelization of the evaluation of fitness functions
         is possible by defining \code{lf$evalPopLapply}.
}
\examples{
pop10<-xegaInitPopulation(10, lFxegaGaGene)
lFxegaGaGene[["evalPopLapply"]]<-ApplyFactory(method="Sequential") 
fit<-xegaEvalPopulation(pop10, lFxegaGaGene)

}
\seealso{
Other Population Layer: 
\code{\link{xegaBestGeneInPopulation}()},
\code{\link{xegaBestInPopulation}()},
\code{\link{xegaInitPopulation}()},
\code{\link{xegaLogEvalsPopulation}()},
\code{\link{xegaNextPopulation}()},
\code{\link{xegaObservePopulation}()},
\code{\link{xegaSummaryPopulation}()}
}
\concept{Population Layer}
