## ----echo=FALSE---------------------------------------------------------------
knitr::opts_chunk$set(
  comment = ''
)

## -----------------------------------------------------------------------------
library(xdvir)

## ----label="tex", echo=FALSE--------------------------------------------------
tex <- r"(\huge $\Phi(z) = \frac{1}{\sqrt{2\pi}} \cdot e^{-\frac{z^2}{2}}$)"

## ----echo=FALSE, message=FALSE------------------------------------------------
library(gggrid)

## ----gaussian, echo=FALSE-----------------------------------------------------
x <- seq(-4, 4, length.out=100)
df <- data.frame(x=x, y=dnorm(x))

## ----ggbase, echo=FALSE-------------------------------------------------------
gg <- ggplot(df) +
    geom_line(aes(x, y))

## ----echo=FALSE, fig.width=6, fig.height=3, message=FALSE---------------------
gg +
    grid_panel(latexGrob(tex, x=0, y=1, hjust="left", vjust="top")) +
    xlim(-4, 4) +
    geom_area(aes(x, y), colour=NA, fill="grey90") +
    geom_line(aes(x, y)) +
    scale_x_continuous(expand=expansion(0)) +
    scale_y_continuous(expand=expansion(c(0))) +
    coord_cartesian(clip="off") +
    theme_minimal() +
    theme(panel.grid=element_blank(),
          axis.title=element_blank(),
          axis.text.y=element_blank(),
          plot.margin=unit(rep(4, 4), "mm")) 

## -----------------------------------------------------------------------------
tex <- r"(\huge $\Phi(z) = \frac{1}{\sqrt{2\pi}} \cdot e^{-\frac{z^2}{2}}$)"

## ----fig.width=3, fig.height=1------------------------------------------------
grid.latex(tex)

## -----------------------------------------------------------------------------
library(lattice)

## ----eval=FALSE---------------------------------------------------------------
# x <- seq(-4, 4, length.out=100)
# df <- data.frame(x=x, y=dnorm(x))

## ----label="lattice-init", echo=FALSE, eval=FALSE-----------------------------
# oopt <- lattice.options(layout.widths=list(left.padding=list(x=0),
#                                            right.padding=list(x=0)),
#                         layout.heights=list(bottom.padding=list(x=0),
#                                             top.padding=list(x=0)))

## ----label="lattice-plot", eval=FALSE-----------------------------------------
# xyplot(y ~ x, df, type="l",
#        panel=function(...) {
#            panel.xyplot(...)
#            grid.latex(tex,
#                       x=unit(2, "mm"),
#                       y=unit(1, "npc") - unit(2, "mm"),
#                       hjust="left", vjust="top")
#        })

## ----label="lattice-final", echo=FALSE, eval=FALSE----------------------------
# lattice.options(oopt)

## ----echo=FALSE, fig.width=6, fig.height=3------------------------------------
oopt <- lattice.options(layout.widths=list(left.padding=list(x=0),
                                           right.padding=list(x=0)),
                        layout.heights=list(bottom.padding=list(x=0),
                                            top.padding=list(x=0)))
xyplot(y ~ x, df, type="l",
       panel=function(...) {
           panel.xyplot(...)
           grid.latex(tex, 
                      x=unit(2, "mm"),
                      y=unit(1, "npc") - unit(2, "mm"),
                      hjust="left", vjust="top")
       })
lattice.options(oopt)

## -----------------------------------------------------------------------------
library(gridGraphics)

## ----label="graphics-init", echo=FALSE, eval=FALSE----------------------------
# opar <- par(mar=c(4, 4, 1, 1))

## ----label="graphics-plot", eval=FALSE----------------------------------------
# plot(y ~ x, df, type="l")
# grid.echo()
# downViewport("graphics-plot-1")
# grid.latex(tex,
#            x=unit(2, "mm"),
#            y=unit(1, "npc") - unit(2, "mm"),
#            hjust="left", vjust="top")

## ----label="graphics-final", echo=FALSE, eval=FALSE---------------------------
# par(opar)

## ----echo=FALSE, fig.width=6, fig.height=3, fig.keep="last"-------------------
opar <- par(mar=c(4, 4, 1, 1))
plot(y ~ x, df, type="l")
grid.echo()
downViewport("graphics-plot-1")
grid.latex(tex, 
           x=unit(2, "mm"),
           y=unit(1, "npc") - unit(2, "mm"),
           hjust="left", vjust="top")
par(opar)

## ----message=FALSE------------------------------------------------------------
library(gggrid)

## ----eval=FALSE---------------------------------------------------------------
# gg <- ggplot(df) +
#     geom_line(aes(x, y))

## ----fig.width=6, fig.height=3------------------------------------------------
gg +
    grid_panel(latexGrob(tex,
                         x=unit(2, "mm"), 
                         y=unit(1, "npc") - unit(2, "mm"), 
                         hjust="left", vjust="top"))

## ----fig.width=6, fig.height=3, message=FALSE---------------------------------
gg +
    labs(title=paste("The Normal Distribution:", tex)) +
    theme(plot.title=element_latex())

## -----------------------------------------------------------------------------
samples <- data.frame(x=rnorm(50), sample=rep(1:5, each=10))
means <- aggregate(samples$x, list(sample=samples$sample), mean)
means$label <- paste0("$\\bar x_", means$sample, "$")

## ----fig.width=6, fig.height=3, message=FALSE---------------------------------
ggplot(samples) +
    geom_vline(xintercept=0, linetype="solid", colour=1, linewidth=.5) +
    geom_point(aes(x, sample), size=4, alpha=.5) +
    geom_point(aes(x, sample), data=means, colour=2, size=4) +
    geom_latex(aes(x, sample, label=label), data=means, 
               size=6, vjust=-.4, colour=2) +
    scale_y_continuous(expand=expansion(.25))

