% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{xQTLdownload_sqtlExp}
\alias{xQTLdownload_sqtlExp}
\title{Download normalized expression of intron for a sQTL pair.}
\usage{
xQTLdownload_sqtlExp(
  variantName = "",
  phenotypeId = "",
  variantType = "auto",
  tissueSiteDetail = ""
)
}
\arguments{
\item{variantName}{(character) name of variant, dbsnp ID and variant id is supported, eg. "rs138420351" and "chr17_7796745_C_T_b38".}

\item{phenotypeId}{A character string. Format like: "chr1:497299:498399:clu_54863:ENSG00000239906.1"}

\item{variantType}{(character) options: "auto", "snpId" or "variantId". Default: "auto".}

\item{tissueSiteDetail}{(character) details of tissues in GTEx can be listed using \code{tissueSiteDetailGTExv8} or \code{tissueSiteDetailGTExv7}}
}
\value{
A data.table object.
}
\description{
Download normalized expression of intron for a sQTL pair.
}
\examples{
# Download sQTL expression in different tissues:
xQTLdownload_sqtlExp(variantName="rs1450891501",
                     phenotypeId="chr1:497299:498399:clu_54863:ENSG00000239906.1",
                     tissueSiteDetail="Lung")

# Dowload sQTL expression using variant ID.
xQTLdownload_sqtlExp(variantName="chr1_1259424_T_C_b38",
                     phenotypeId=" chr1:1487914:1489204:clu_52051:ENSG00000160072.19",
                     tissueSiteDetail="Adipose - Subcutaneous")
}
