% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_to_x3p.R
\name{stl_to_x3p}
\alias{stl_to_x3p}
\title{Convert an STL file to an x3p file}
\usage{
stl_to_x3p(stl)
}
\arguments{
\item{stl}{STL file object or path to the file}
}
\value{
x3p object
}
\description{
STL files describe 3d objects as mesh objects. Here, we assume that the 3d object consists of a 3d surface on the top of a rectangular, equi-spaced 2d grid.
We further assume, that each node of the STL file describes the x-y location of an actual measurement. These measurements are then converted into the surface matrix of an x3p object.
The resolution is derived from the distance between consecutive x and y nodes.
}
\examples{
\dontrun{
# the website https://touchterrain.geol.iastate.edu/ allows a download
# of a 3d printable terrain model. For an example we suggest to download a file from there.
gc <- rgl::readSTL("<PATH TO STL FILE>", plot=FALSE)
x3p <- stl_to_x3p(gc)
}
}
