\name{testFunction}
\alias{testFunction}
\title{
Test function
}
\description{
Apply data to function signature and record results.
}
\usage{
testFunction(function_f_1,
             generatedData_l,
             functionName_s_1 = deparse(substitute(function_f_1)))
}
\arguments{
  \item{function_f_1}{ a single \R function, offensive programming ready, with
  using semantic argument names }
  \item{generatedData_l}{
data to apply to the function. Could be generated by \code{\link{generateData}}
function is desired.
}
  \item{functionName_s_1}{A character vector of length 1, holding the function name.
  This is particularly useful, in scripts.
}
}
\details{
Executes code and captures execution context and result, for posterior analysis.
}
\value{
A \code{list} with names \code{generation}, \code{data}, \code{context}, and \code{n},
representing respectively, argument name generation, data, data type generation context, and
the number of data generated at the first level.

Generated data are ready for use and accessible using the \code{data} name of
the \code{list}.
}
\seealso{
Refer to \code{\link{opwf}}.
}
\examples{
# typical example
op_sum <- opwf(sum, c('...', 'removeNA_b_1'))
op_sum_atr <- list('...' = c('i', 'd', 'c'))
ec <- setGenerationContext(0, TRUE, FALSE)
gd <- generateData(op_sum, op_sum_atr, ec, erc$hetero_vector[[1]], dac$none)
tf <- testFunction(op_sum, gd$data)
}
\keyword{ programming }
\keyword{ utilities }
\concept{ meta testing }
