% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/race_prediction_funs.R
\name{modfuns}
\alias{modfuns}
\alias{.predict_race_old}
\alias{predict_race_new}
\alias{predict_race_me}
\title{Internal model fitting functions}
\usage{
.predict_race_old(
  voter.file,
  census.surname = TRUE,
  surname.only = FALSE,
  surname.year = 2010,
  name.dictionaries = NULL,
  census.geo,
  census.key,
  census.data = NULL,
  age = FALSE,
  sex = FALSE,
  year = "2010",
  party,
  retry = 3,
  impute.missing = TRUE,
  use.counties = FALSE
)

predict_race_new(
  voter.file,
  names.to.use,
  year = "2010",
  age = FALSE,
  sex = FALSE,
  census.geo,
  census.key = NULL,
  name.dictionaries,
  surname.only = FALSE,
  census.data = NULL,
  retry = 0,
  impute.missing = TRUE,
  census.surname = FALSE,
  use.counties = FALSE
)

predict_race_me(
  voter.file,
  names.to.use,
  year = "2010",
  age = FALSE,
  sex = FALSE,
  census.geo,
  census.key,
  name.dictionaries,
  surname.only = FALSE,
  census.data = NULL,
  retry = 0,
  impute.missing = TRUE,
  census.surname = FALSE,
  use.counties = FALSE,
  race.init,
  ctrl
)
}
\arguments{
\item{voter.file}{See documentation in \code{race_predict}.}

\item{census.surname}{See documentation in \code{race_predict}.}

\item{surname.only}{See documentation in \code{race_predict}.}

\item{surname.year}{See documentation in \code{race_predict}.}

\item{name.dictionaries}{See documentation in \code{race_predict}.}

\item{census.geo}{See documentation in \code{race_predict}.}

\item{census.key}{See documentation in \code{race_predict}.}

\item{census.data}{See documentation in \code{race_predict}.}

\item{age}{See documentation in \code{race_predict}.}

\item{sex}{See documentation in \code{race_predict}.}

\item{year}{See documentation in \code{race_predict}.}

\item{party}{See documentation in \code{race_predict}.}

\item{retry}{See documentation in \code{race_predict}.}

\item{impute.missing}{See documentation in \code{race_predict}.}

\item{use.counties}{A logical, defaulting to FALSE. Should census data be filtered by counties available in \var{census.data}?}

\item{names.to.use}{See documentation in \code{race_predict}.}

\item{race.init}{See documentation in \code{race_predict}.}

\item{ctrl}{See \code{control} in documentation for \code{race_predict}.}
}
\value{
See documentation in \code{race_predict}.
}
\description{
These functions are intended for internal use only. Users should use the
\code{race_predict} interface rather any of these functions directly.
}
\details{
These functions fit different versions of WRU. \code{.predict_race_old} fits
the original WRU model, also known as BISG with census-based surname dictionary.
\code{.predict_race_new} fits a new version of BISG which uses a new, augmented
surname dictionary, and can also accommodate the use of first and middle
name information. Finally, \code{.predict_race_me} fits a fully Bayesian Improved
Surname Geocoding model (fBISG), which fits a model with measurement-error
correction of erroneous zeros in census tables, in addition to also accommodating
the augmented surname dictionary, and the first and middle name
dictionaries when making predictions.
}
\section{.predict_race_old}{

Original WRU race prediction function, implementing classical BISG with census-based
surname dictionary.
}

\section{.predict_race_new }{

New race prediction function, implementing classical BISG with augmented
surname dictionary, as well as first and middle name information.
}

\section{.predict_race_me}{

New race prediction function, implementing fBISG (i.e. measurement
error correction, fully Bayesian model) with augmented
surname dictionary, as well as first and middle name information.
}

\keyword{internal}
