% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unpack.R
\name{grab_assignments_from_dots}
\alias{grab_assignments_from_dots}
\title{Re-write captured \code{...} arguments as assignments.}
\usage{
grab_assignments_from_dots(captured_dots)
}
\arguments{
\item{captured_dots}{captured \code{...}.}
}
\value{
named character vector describing the desired mapping.
}
\description{
Re-write captured \code{...} arguments as a \code{c(DESTINATION = TARGET)} character vector.
Suggested capture code is: \code{as.list(do.call(bquote, list(substitute(list(...)))))[-1]}
}
\examples{

f <- function(...) {
  unpack_environment <- parent.frame(n = 1)
  captured_dots <- as.list(do.call(bquote,
                                   list(substitute(list(...)),
                                        where = unpack_environment),
                                   envir = unpack_environment))[-1]
  grab_assignments_from_dots(captured_dots)
}
f(a, c = d, e := f, g <- h, i -> j)
# should equal c('a', 'c' = 'd', 'e' = 'f', 'g' = 'h', 'j' = 'i')

}
\keyword{internal}
