% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string_interpolation.R
\name{sinterp}
\alias{sinterp}
\title{Dot substitution.}
\usage{
sinterp(
  str,
  ...,
  envir = parent.frame(),
  enclos = parent.frame(),
  match_pattern = "\\\\.\\\\((([^()]+)|(\\\\([^()]*\\\\)))+\\\\)",
  removal_patterns = c("^\\\\.\\\\(", "\\\\)$")
)
}
\arguments{
\item{str}{charater string to be substituted into}

\item{...}{force later arguments to bind by name}

\item{envir}{environemnt to look for values}

\item{enclos}{enclosing evaluation environment}

\item{match_pattern}{regexp to find substitution targets.}

\item{removal_patterns}{regexps to remove markers from substitution targets.}
}
\value{
modified strings
}
\description{
String interpolation using \code{bquote}-stype .() notation. Pure R, no C/C++ code called.
}
\details{
See also
\url{https://CRAN.R-project.org/package=R.utils},
\url{https://CRAN.R-project.org/package=rprintf},
and \url{https://CRAN.R-project.org/package=glue}.
}
\examples{

x <- 7
sinterp("x is .(x), x+1 is .(x+1)\n.(x) is odd is .(x\%\%2 == 1)")

# Because matching is done by a regular expression we
# can not use arbitrary depths of nested parenthesis inside
# the interpolation region.  The default regexp allows
# one level of nesting (and one can use {} in place
# of parens in many places).
sinterp("sin(x*(x+1)) is .(sin(x*{x+1}))")

# We can also change the delimiters,
# in this case to !! through the first whitespace.
sinterp(c("x is !!x , x+1 is !!x+1\n!!x  is odd is !!x\%\%2==1"),
        match_pattern = '!![^[:space:]]+[[:space:]]?',
        removal_patterns = c("^!!", "[[:space:]]?$"))

}
