% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asSepList.R
\name{asSepList}
\alias{asSepList}
\title{Organize Data as Separate List-Entries}
\usage{
asSepList(
  y,
  minLen = 4,
  asNumeric = TRUE,
  exclElem = NULL,
  sep = "_",
  fillNames = TRUE,
  silent = FALSE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{y}{list to be separated/split in vectors}

\item{minLen}{(integer) min length (or number of rows), as add'l element to eliminate arguments given without names when asSepList is called in vioplot2}

\item{asNumeric}{(logical) to transform all list-elements in simple numeric vectors (won't work if some entries are character)}

\item{exclElem}{(character) optinal names to exclude if any (lazy matching) matches (to exclude other arguments be misinterpreted as data)}

\item{sep}{(character) separator when combining name of list-element to colames}

\item{fillNames}{(logical) add names for list-elements/ series when not given}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of messages produced}

\item{debug}{(logical) display additional messages for debugging}
}
\value{
This function returns a list, partially unlisted to vectors
}
\description{
\code{asSepList} allows reorganizing most types of input into a list with separate numeric vectors. For example, matrixes or data.frames will be split into separate columns
(differnt to \code{\link[wrMisc]{partUnlist}} which maintains the original structure). This function also works with lists of lists.
This function may be helpful for reorganizing data for plots.
}
\examples{
bb <- list(fa=gl(2,2), c=31:33, L2=matrix(21:28,nc=2),
  li=list(li1=11:14, li2=data.frame(41:44)))
asSepList(bb)
## multi data-frame examples
ca <- data.frame(a=11:15, b=21:25, c=31:35)
cb <- data.frame(a=51:53, b=61:63)
cc <- list(gl(3,2), ca, cb, 91:94, short=81:82, letters[1:5])
asSepList(cc)
cd <- list(e1=gl(3,2), e2=ca, e3=cb, e4=91:94, short=81:82, e6=letters[1:5])
asSepList(cd)
}
\seealso{
\code{\link[wrMisc]{partUnlist}}, \code{\link[base]{unlist}}
}
