% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_p2p.R
\name{network_p2p}
\alias{network_p2p}
\title{Create a network plot with the person-to-person query}
\usage{
network_p2p(
  data,
  hrvar = "Organization",
  display = "hrvar",
  return = "plot",
  path = paste0("network_p2p_", display),
  desc_hrvar = c("Organization", "LevelDesignation", "FunctionType"),
  bg_fill = "#FFFFFF",
  font_col = "grey20",
  legend_pos = "bottom",
  palette = "rainbow",
  node_alpha = 0.7,
  edge_alpha = 1,
  res = 0.5,
  seed = 1,
  algorithm = "mds",
  size_threshold = 5000,
  weight = "StrongTieScore"
)
}
\arguments{
\item{data}{Data frame containing a person-to-person query.}

\item{hrvar}{String containing the label for the HR attribute.}

\item{display}{String determining what output to return. Valid values
include:
\itemize{
\item \code{"hrvar"} (default): compute analysis or visuals without computing
communities.
\item \code{"louvain"}: compute analysis or visuals with community detection, using
the Louvain algorithm.
\item \code{"leiden"}: compute analysis or visuals with community detection, using
the Leiden algorithm. This requires all the pre-requisites of the
\strong{leiden} package installed, which includes Python and \strong{reticulate}.
}}

\item{return}{String specifying what output to return. This must be one of the
following strings:
\itemize{
\item \code{'plot'} (default)
\item \code{'sankey'}
\item \code{'table'}
\item \code{'data'}
\item \code{'describe'}
\item \code{'network'}
}

See \code{Value} for more information.}

\item{path}{File path for saving the PDF output. Defaults to a timestamped
path based on current parameters.}

\item{desc_hrvar}{Character vector of length 3 containing the HR attributes
to use when returning the \code{"describe"} output. See \code{network_describe()}.}

\item{bg_fill}{String to specify background fill colour.}

\item{font_col}{String to specify font and link colour.}

\item{legend_pos}{String to specify position of legend. Defaults to
\code{"bottom"}. See \code{ggplot2::theme()}. This is applicable for both the
'ggraph' and the fast plotting method. Valid inputs include:
\itemize{
\item \code{"bottom"}
\item \code{"top"}
\item \code{"left"}
-\code{"right"}
}}

\item{palette}{Function for generating a colour palette with a single
argument \code{n}. Uses "rainbow" by default.}

\item{node_alpha}{A numeric value between 0 and 1 to specify the transparency
of the nodes. Defaults to 0.7.}

\item{edge_alpha}{A numeric value between 0 and 1 to specify the transparency
of the edges (only for 'ggraph' mode). Defaults to 1.}

\item{res}{Resolution parameter to be passed to \code{leiden::leiden()}. Defaults
to 0.5.}

\item{seed}{Seed for the random number generator passed to \code{leiden::leiden()}
to ensure consistency. Only applicable when \code{display} is set to \code{"leiden"}.}

\item{algorithm}{String to specify the node placement algorithm to be used.
Defaults to \code{"mds"} for the deterministic multi-dimensional scaling of
nodes. See
\url{https://rdrr.io/cran/ggraph/man/layout_tbl_graph_igraph.html} for a full
list of options.}

\item{size_threshold}{Numeric value representing the maximum number of edges
before \code{network_leiden()} switches to use a more efficient, but less
elegant plotting method (native igraph). Defaults to 5000. Set as \code{0} to
coerce to a fast plotting method every time, and \code{Inf} to always use the
default plotting method (with 'ggraph').}

\item{weight}{String to specify which column to use as weights for the
network. Defaults to \verb{"StrongTieScore}. To create a graph without weights,
supply \code{NULL} to this argument.}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{'plot'}: return a network plot.
\item \code{'sankey'}: return a sankey plot combining communities and HR attribute.
This is only valid if a community detection method is selected at
\code{display}.
\item \code{'table'}: return a vertex summary table with counts in communities and
HR attribute.
\item \code{'data'}: return a vertex data file that matches vertices with
communities and HR attributes.
\item \code{'describe'}: return a list of data frames which describe each of the
identified communities. The first data frame is a summary table of all the
communities. This is only valid if a community detection method is selected
at \code{display}.
\item \code{'network'}: return 'igraph' object.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Analyse a person-to-person (P2P) network query, with multiple visualisation
and analysis output options. Pass a data frame containing a person-to-person
query and return a network visualization. Options are available for community
detection using either the Louvain or the Leiden algorithms.
}
\section{Running Leiden communities}{


Running Leiden communities requires python dependencies installed.
You can run the following:\if{html}{\out{<div class="R">}}\preformatted{# Return a network plot to console, coloured by Leiden communities
  p2p_data \%>\%
    network_p2p(display = "leiden",
                path = NULL,
                return = "plot")
}\if{html}{\out{</div>}}

When installing the 'leiden' package, you may be required to install the Python
libraries 'python-igraph' and 'leidenalg'. You can install them with:\if{html}{\out{<div class="R">}}\preformatted{reticulate::py_install("python-igraph")
reticulate::py_install("leidenalg")
}\if{html}{\out{</div>}}
}

\examples{
# Simulate a small person-to-person dataset
p2p_data <- p2p_data_sim(size = 50)

# Return a network plot to console, coloured by hrvar
p2p_data \%>\%
  network_p2p(display = "hrvar",
              path = NULL,
              return = "plot")

# Return a network plot to console, coloured by Louvain communities
p2p_data \%>\%
  network_p2p(display = "louvain",
              path = NULL,
              return = "plot")


# Return a network plot to console
# Coloured by Leiden communities
# Using Fruchterman-Reingold force-directed layout algorithm
# Force the use of fast plotting method
p2p_data \%>\%
  network_p2p(display = "hrvar",
              path = NULL,
              return = "plot",
              algorithm = "lgl",
              size_threshold = 0)

# Return a data frame matching HR variable and communities to nodes
# Using Louvain communities
p2p_data \%>\%
  network_p2p(display = "louvain",
              return = "data",
              algorithm = "fr")

}
\seealso{
Other Network: 
\code{\link{external_network_plot}()},
\code{\link{g2g_data}},
\code{\link{internal_network_plot}()},
\code{\link{network_describe}()},
\code{\link{network_g2g}()},
\code{\link{network_leiden}()},
\code{\link{network_louvain}()},
\code{\link{p2p_data_sim}()}
}
\concept{Network}
