% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meeting_quality.R
\name{meeting_quality}
\alias{meeting_quality}
\title{Run a meeting habits / meeting quality analysis}
\usage{
meeting_quality(
  data,
  hrvar = "Organization",
  metric_x = "Low_quality_meeting_hours",
  mingroup = 5,
  return = "plot"
)
}
\arguments{
\item{data}{A Standard Person Query dataset in the form of a data frame.}

\item{hrvar}{HR Variable by which to split metrics, defaults to
"Organization" but accepts any character vector, e.g. "LevelDesignation"}

\item{metric_x}{String specifying which variable to show in the x-axis when
returning a plot. Must be one of the following:
\itemize{
\item \code{"Low_quality_meeting_hours"} (default)
\item \code{"After_hours_meeting_hours"}
\item \code{"Conflicting_meeting_hours"}
\item \code{"Multitasking_meeting_hours"}
\item Any \emph{meeting hour} variable that can be divided by \code{Meeting_hours}
}}

\item{mingroup}{Numeric value setting the privacy threshold / minimum group
size. Defaults to 5.}

\item{return}{String specifying what to return. This must be one of the
following strings: - \code{"plot"} - \code{"table"}}
}
\value{
A different output is returned depending on the value passed to the
\code{return} argument:
\itemize{
\item \code{"plot"}: 'ggplot' object. A bubble plot for the metric.
\item \code{"table"}: data frame. A summary table for the metric.
}
}
\description{
Return an analysis of Meeting Quality with a bubble plot, using
a Standard Person Query as an input.
}
\examples{
# Return plot
meeting_quality(sq_data, return = "plot")

# Return plot - showing multi-tasking \%
meeting_quality(sq_data,
                metric_x = "Multitasking_meeting_hours",
                return = "plot")

# Return summary table
meeting_quality(sq_data, return = "table")

}
\seealso{
Other Visualization: 
\code{\link{afterhours_dist}()},
\code{\link{afterhours_fizz}()},
\code{\link{afterhours_line}()},
\code{\link{afterhours_rank}()},
\code{\link{afterhours_summary}()},
\code{\link{afterhours_trend}()},
\code{\link{collaboration_area}()},
\code{\link{collaboration_dist}()},
\code{\link{collaboration_fizz}()},
\code{\link{collaboration_line}()},
\code{\link{collaboration_rank}()},
\code{\link{collaboration_sum}()},
\code{\link{collaboration_trend}()},
\code{\link{create_bar_asis}()},
\code{\link{create_bar}()},
\code{\link{create_boxplot}()},
\code{\link{create_bubble}()},
\code{\link{create_dist}()},
\code{\link{create_fizz}()},
\code{\link{create_line_asis}()},
\code{\link{create_line}()},
\code{\link{create_period_scatter}()},
\code{\link{create_rank}()},
\code{\link{create_sankey}()},
\code{\link{create_scatter}()},
\code{\link{create_stacked}()},
\code{\link{create_trend}()},
\code{\link{email_dist}()},
\code{\link{email_fizz}()},
\code{\link{email_line}()},
\code{\link{email_rank}()},
\code{\link{email_summary}()},
\code{\link{email_trend}()},
\code{\link{external_network_plot}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count}()},
\code{\link{internal_network_plot}()},
\code{\link{keymetrics_scan}()},
\code{\link{meeting_dist}()},
\code{\link{meeting_fizz}()},
\code{\link{meeting_line}()},
\code{\link{meeting_rank}()},
\code{\link{meeting_summary}()},
\code{\link{meeting_trend}()},
\code{\link{meetingtype_dist_ca}()},
\code{\link{meetingtype_dist_mt}()},
\code{\link{meetingtype_dist}()},
\code{\link{meetingtype_summary}()},
\code{\link{mgrcoatt_dist}()},
\code{\link{mgrrel_matrix}()},
\code{\link{one2one_dist}()},
\code{\link{one2one_fizz}()},
\code{\link{one2one_freq}()},
\code{\link{one2one_line}()},
\code{\link{one2one_rank}()},
\code{\link{one2one_sum}()},
\code{\link{one2one_trend}()},
\code{\link{period_change}()},
\code{\link{workloads_dist}()},
\code{\link{workloads_fizz}()},
\code{\link{workloads_line}()},
\code{\link{workloads_rank}()},
\code{\link{workloads_summary}()},
\code{\link{workloads_trend}()},
\code{\link{workpatterns_area}()},
\code{\link{workpatterns_rank}()}

Other Meetings: 
\code{\link{meeting_dist}()},
\code{\link{meeting_extract}()},
\code{\link{meeting_fizz}()},
\code{\link{meeting_line}()},
\code{\link{meeting_rank}()},
\code{\link{meeting_skim}()},
\code{\link{meeting_summary}()},
\code{\link{meeting_tm_report}()},
\code{\link{meeting_trend}()},
\code{\link{meetingtype_dist_ca}()},
\code{\link{meetingtype_dist_mt}()},
\code{\link{meetingtype_dist}()},
\code{\link{meetingtype_summary}()}
}
\concept{Meetings}
\concept{Visualization}
