/*
 * Decompiled with CFR 0.152.
 */
package com.nexagis.jawbone.demo;

import com.nexagis.jawbone.Dictionary;
import com.nexagis.jawbone.IndexTerm;
import com.nexagis.jawbone.PartOfSpeech;
import com.nexagis.jawbone.Pointer;
import com.nexagis.jawbone.Synset;
import com.nexagis.jawbone.filter.WildcardFilter;
import java.util.Iterator;

public final class JawboneDemo {
    private JawboneDemo() {
    }

    public static void main(String[] stringArray) {
        Dictionary.initialize("c:/Program Files/WordNet/2.1/dict");
        Dictionary dictionary = Dictionary.getInstance();
        WildcardFilter wildcardFilter = new WildcardFilter("car*", true);
        Iterator<IndexTerm> iterator = dictionary.getIndexTermIterator(PartOfSpeech.NOUN, 1, wildcardFilter);
        while (iterator.hasNext()) {
            int n;
            IndexTerm indexTerm = iterator.next();
            System.out.println(indexTerm.toString());
            int n2 = indexTerm.getPointerCount();
            if (n2 > 0) {
                System.out.println("\nThis term has " + Integer.toString(n2) + " pointers");
                String[] stringArray2 = indexTerm.getPointers();
                for (int i = 0; i < n2; ++i) {
                    String string = Pointer.getPointerDescription(indexTerm.getPartOfSpeech(), stringArray2[i]);
                    System.out.println(stringArray2[i] + ": " + string);
                }
            }
            if ((n = indexTerm.getSynsetCount()) <= 0) continue;
            System.out.println("\nThis term has " + Integer.toString(n) + " synsets");
            Synset[] synsetArray = indexTerm.getSynsets();
            for (int i = 0; i < n; ++i) {
                System.out.println(synsetArray[i].toString());
            }
        }
        System.out.println("Demo processing finished.");
    }
}

