% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worcs_project.R
\name{add_preregistration}
\alias{add_preregistration}
\title{Add Rmarkdown preregistration}
\usage{
add_preregistration(
  worcs_directory = ".",
  preregistration = "COS",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{worcs_directory}{Character, indicating the directory
in which to create the manuscript files. Default: '.', which points to the
current working directory.}

\item{preregistration}{Character, indicating what template to use for the
preregistration. Default: \code{"COS"}; use \code{"None"} to omit a
preregistration. See Details for other available choices.}

\item{verbose}{Logical. Whether or not to print messages to the console
during project creation. Default: TRUE}

\item{...}{Additional arguments passed to and from functions.}
}
\value{
No return value. This function is called for its side effects.
}
\description{
Adds an Rmarkdown preregistration template to a 'worcs' project.
}
\details{
Available choices include the templates
\code{"COS", "VantVeer", "Brandt", "AsPredicted"}, which are imported from the
\code{\link[prereg]{cos_prereg}} package, and documented there. Furthermore,
several unique templates are included with \code{worcs}:
\itemize{
  \item{\code{"PSS"}}{Preregistration and Sharing Software (Krypotos,
  Klugkist, Mertens, & Engelhard, 2019)}
  \item{\code{"Secondary"}}{Preregistration for secondary analyses (Mertens &
  Krypotos, 2019)}
}
}
\examples{
the_test <- "worcs_prereg"
old_wd <- getwd()
dir.create(file.path(tempdir(), the_test))
file.create(file.path(tempdir(), the_test, ".worcs"))
add_preregistration(file.path(tempdir(), the_test),
                    preregistration = "COS")
setwd(old_wd)
unlink(file.path(tempdir(), the_test))
}
