% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worcs_project.R
\name{add_manuscript}
\alias{add_manuscript}
\title{Add Rmarkdown manuscript}
\usage{
add_manuscript(
  worcs_directory = ".",
  manuscript = "APA6",
  remote_repo = "https",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{worcs_directory}{Character, indicating the directory
in which to create the manuscript files. Default: '.', which points to the
current working directory.}

\item{manuscript}{Character, indicating what template to use for the
'R Markdown' manuscript. Default: 'APA6'. Available choices include:
\code{"APA6", "github_document", "None", "ams_article", "asa_article",
"biometrics_article", "copernicus_article", "ctex", "elsevier_article",
"frontiers_article", "ieee_article", "joss_article", "jss_article",
"mdpi_article", "mnras_article", "oup_article", "peerj_article",
"plos_article", "pnas_article", "rjournal_article", "rsos_article",
"sage_article", "sim_article", "springer_article", "tf_article"}.
For more information about \code{APA6}, see the 'papaja' package, at
<https://github.com/crsh/papaja>.
For more information about \code{github_document}, see
\code{\link[rmarkdown]{github_document}}. The remaining formats are
documented in the 'rticles' package.}

\item{remote_repo}{Character, 'https' link to the remote repository for
this project. This link should have the form \code{https://[...].git}.
If a valid remote repository link is provided, a commit will
be made containing the 'README.md' file, and will be pushed to the remote
repository. Default: 'https'. When no 'https' address is provided, an 'SSH'
address of the form \code{git@[...].git} is also accepted.}

\item{verbose}{Logical. Whether or not to print messages to the console
during project creation. Default: TRUE}

\item{...}{Additional arguments passed to and from functions.}
}
\value{
No return value. This function is called for its side effects.
}
\description{
Adds an Rmarkdown manuscript to a 'worcs' project.
}
\examples{
the_test <- "worcs_manuscript"
old_wd <- getwd()
dir.create(file.path(tempdir(), the_test))
file.create(file.path(tempdir(), the_test, ".worcs"))
add_manuscript(file.path(tempdir(), the_test),
              manuscript = "github_document")
setwd(old_wd)
unlink(file.path(tempdir(), the_test))
}
