% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_aqi.R
\name{daily_aqi}
\alias{daily_aqi}
\title{Retrieve the air quality data.}
\usage{
daily_aqi(
  aqs_api_email,
  aqs_api_key,
  fips_list,
  metric_list = c(81102, 88101, 42101, 44201, 42602),
  year_min = 2015,
  year_max = 2015
)
}
\arguments{
\item{aqs_api_email}{AQS API email}

\item{aqs_api_key}{AQS API key}

\item{fips_list}{A vector of FIPS codes per county. One can use the output from the \code{\link{get_counties}} function as follows:
\code{fips_list=pull(counties, 'fips')}}

\item{metric_list}{list of codes that represent different air quality metrics
81101 - PM10, 88101 - PM2.5, 42101 - CO, 42602 - NO2, 44201 - Ozone.}

\item{year_min}{earliest year to pull the air quality data for, starts January 1st.}

\item{year_max}{latest year to pull the air quality data for, ends December 31st.}
}
\value{
A dataframe of daily AQI data, including the metrics specified.
}
\description{
Retrieve the air quality data.
}
\note{
The function uses the AQS API to fetch the data from the API endpoints. Use the following service to register as a user:
A verification email will be sent to the email account specified. To register using the email address
create and request this link (Replace \email{myemail@example.com} in the example with your email address.):
(\url{https://aqs.epa.gov/data/api/signup?email=myemail@example.com})
You then need to set the email and the key in the .Renviron file as follows, i.e.
aqs_api_email=\email{myemail@example.com}
aqs_api_key=testkey1234

AQS AQI has request limits and ToS: (\url{https://aqs.epa.gov/aqsweb/documents/data_api.html#terms}). The function intentionally
adds a 10 second delay between each call (per year, per county) but pay attention to the limits as the account may be disabled.
It is also recommended to process no more than five years at a time, as the API request occasionally times out and data may be lost.
}
\examples{
\dontrun{
aqs_api_email = Sys.getenv("aqs_api_email")
aqs_api_key = Sys.getenv("aqs_api_key")

state_codes <- get_state_code(aqs_api_email = aqs_api_email,
                              aqs_api_key = aqs_api_key,
                              state_names = c('California'))
counties <- get_counties(aqs_api_email = aqs_api_email,
                         aqs_api_key = aqs_api_key,
                         state_codes = state_codes)
aqi <- daily_aqi(aqs_api_email = aqs_api_email,
                 aqs_api_key = aqs_api_key,
                 fips_list = counties$fips,
                 year_min = 2015,
                 year_max = 2015)
}
}
