% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precision_agriculture.R
\name{wbt_reconcile_multiple_headers}
\alias{wbt_reconcile_multiple_headers}
\title{Reconcile multiple headers}
\usage{
wbt_reconcile_multiple_headers(
  input,
  region_field,
  yield_field,
  output,
  radius = NULL,
  min_yield = NULL,
  max_yield = NULL,
  mean_tonnage = NULL,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{input}{Name of the input points shapefile.}

\item{region_field}{Name of the attribute containing region data.}

\item{yield_field}{Name of the attribute containing yield data.}

\item{output}{Name of the output points shapefile.}

\item{radius}{Optional search radius, in metres. Only specify this value if you want to calculate locally normalized yield.}

\item{min_yield}{Minimum yield value in output.}

\item{max_yield}{Maximum yield value in output.}

\item{mean_tonnage}{Use this optional parameter to force the output to have a certain overall average tonnage.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
This tool adjusts the crop yield values for data sets collected with multiple headers or combines.
}
\keyword{PrecisionAgriculture}
