% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whatr-html.R
\name{whatr_html}
\alias{whatr_html}
\title{Return the right J! Archive HTML document}
\usage{
whatr_html(x, out = c("showgame", "showscores"))
}
\arguments{
\item{x}{Any kind of J! Archive game identifier.}

\item{out}{One of "showscores" or "showgame" used for \code{\link[=whatr_scores]{whatr_scores()}} or
\code{\link[=whatr_clues]{whatr_clues()}}, etc. respectively. Either document can be returned from
the input of the other.}
}
\value{
A J! Archive \code{html_document}.
}
\description{
To avoid downloading and reading the J! Archive over and over, this function
can be used to return an HTML document from one of four types of input:
\enumerate{
\item Game ID (6304)
\item Show number ("#8006")
\item Air date ("2019-06-03")
\item HTML document itself
}
}
\examples{
whatr_html(x = 6304, out = "showscores")
whatr_html(x = "2019-06-03", out = "showgame")
whatr_html("#8006", "showgame") \%>\% whatr_clues()
}
