% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/multipoint.R
\name{multipoint}
\alias{multipoint}
\title{Make WKT multipoint objects}
\usage{
multipoint(..., fmt = 16)
}
\arguments{
\item{...}{A GeoJSON-like object representing a Point, LineString, Polygon, MultiPolygon, etc.}

\item{fmt}{Format string which indicates the number of digits to display after the
decimal point when formatting coordinates. Max: 20}
}
\description{
Make WKT multipoint objects
}
\examples{
## empty multipoint
multipoint("empty")
# multipoint("stuff")

# numeric
multipoint(c(100.000, 3.101), c(101.000, 2.100), c(3.140, 2.180))

# data.frame
df <- us_cities[1:25, c('long', 'lat')]
multipoint(df)

# matrix
mat <- matrix(c(df$long, df$lat), ncol = 2)
multipoint(mat)

# list
multipoint(list(c(100.000, 3.101), c(101.000, 2.100), c(3.140, 2.180)))
}
\seealso{
Other R.objects: \code{\link{circularstring}};
  \code{\link{geometrycollection}};
  \code{\link{linestring}}; \code{\link{multilinestring}};
  \code{\link{multipolygon}}; \code{\link{point}};
  \code{\link{polygon}}
}

