% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\encoding{UTF-8}
\name{mixture_em_cpp}
\alias{mixture_em_cpp}
\title{EM-Algorithm using Newton-Raphson Method}
\usage{
mixture_em_cpp(
  x,
  status,
  post,
  distribution = "weibull",
  k = 2L,
  method = "EM",
  n_iter = 100L,
  conv_limit = 1e-06
)
}
\arguments{
\item{x}{a numeric vector which consists of lifetime data. Lifetime
data could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{status}{a vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{post}{a numeric matrix specifying initial a-posteriori probabilities.
The number of rows have to be in line with observations \code{x} and the
number of columns must equal the mixture components \code{k}.}

\item{distribution}{supposed distribution of mixture model components.
The value must be \code{"weibull"}. Other distributions have not been
implemented yet.}

\item{k}{integer of mixture components, default is 2.}

\item{method}{default method is \code{"EM"}. Other methods have not been
implemented yet.}

\item{n_iter}{integer defining the maximum number of iterations.}

\item{conv_limit}{numeric value defining the convergence limit.}
}
\value{
Returns a list with the following components:
  \itemize{
  \item \code{coefficients} : A matrix with estimated Weibull parameters. In the
    first row the estimated scale parameters \eqn{\eta} and in the second the
    estimated shape parameters \eqn{\beta} are provided. The first column belongs
    to the first mixture component and so forth.
  \item \code{posteriori} : A matrix with estimated a-posteriori probabilities.
  \item \code{priori} : A vector with estimated a-priori probabilities.
  \item \code{logL} : The value of the complete log-likelihood.}
}
\description{
This method uses the EM-Algorithm to estimate the parameters of a univariate
mixture model. Until now, the mixture model can consist of k two-parametric
Weibull distributions. The Weibull distributions are parameterized with scale
\eqn{\eta} and shape \eqn{\beta}. In M-step these parameters are estimated using
Newton-Raphson. This function is implemented in c++ and is called in function
\code{\link{mixmod_em}}.
}
\references{
Doganaksoy, N.; Hahn, G.; Meeker, W. Q., Reliability Analysis by
  Failure Mode, Quality Progress, 35(6), 47-52, 2002
}
\keyword{internal}
