% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_distributions.R
\name{dist_delay_register}
\alias{dist_delay_register}
\title{Parameter Estimation of the Delay in Registration Distribution}
\usage{
dist_delay_register(date_prod, date_register, distribution = "lognormal")
}
\arguments{
\item{date_prod}{a vector of class \code{"character"} or \code{"Date"}, in the
format "yyyy-mm-dd", indicating the date of production of a unit.
If no date is available use \code{NA}.}

\item{date_register}{a vector of class \code{"character"} or \code{"Date"}, in
the format "yyyy-mm-dd", indicating the date of registration of a unit.
If no date is available use \code{NA}.}

\item{distribution}{supposed distribution of the random variable. The default
value is \code{"lognormal"}. So far no other distribution is implemented.}
}
\value{
A named vector of estimated parameters for the specified
  distribution.
}
\description{
This function introduces a delay random variable by calculating the time
difference between the registration and production date for the sample units
and afterwards estimates the parameter(s) of a supposed distribution,
using MLE.
}
\examples{
date_of_production   <- c("2014-07-28", "2014-02-17", "2014-07-14",
                          "2014-06-26", "2014-03-10", "2014-05-14",
                          "2014-05-06", "2014-03-07", "2014-03-09",
                          "2014-04-13", "2014-05-20", "2014-07-07",
                          "2014-01-27", "2014-01-30", "2014-03-17",
                          "2014-02-09", "2014-04-14", "2014-04-20",
                          "2014-03-13", "2014-02-23", "2014-04-03",
                          "2014-01-08", "2014-01-08")
date_of_registration <- c(NA, "2014-03-29", "2014-12-06", "2014-09-09",
                          NA, NA, "2014-06-16", NA, "2014-05-23",
                          "2014-05-09", "2014-05-31", NA, "2014-04-13",
                          NA, NA, "2014-03-12", NA, "2014-06-02",
                          NA, "2014-03-21", "2014-06-19", NA, NA)

params_delay_regist  <- dist_delay_register(
                                    date_prod = date_of_production,
                                    date_register = date_of_registration,
                                    distribution = "lognormal")
}
