% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_lineups.R
\name{wnba_leaguelineupviz}
\alias{wnba_leaguelineupviz}
\title{\strong{Get WNBA Stats API League Lineup Visual Data}}
\usage{
wnba_leaguelineupviz(
  conference = "",
  date_from = "",
  date_to = "",
  division = "",
  game_segment = "",
  group_quantity = 5,
  last_n_games = 0,
  league_id = "10",
  location = "",
  measure_type = "Base",
  minutes_min = 10,
  month = 0,
  opponent_team_id = 0,
  outcome = "",
  po_round = "",
  pace_adjust = "N",
  per_mode = "Totals",
  period = 0,
  plus_minus = "N",
  rank = "N",
  season = most_recent_wnba_season() - 1,
  season_segment = "",
  season_type = "Regular Season",
  shot_clock_range = "",
  team_id = "",
  vs_conference = "",
  vs_division = "",
  ...
)
}
\arguments{
\item{conference}{conference}

\item{date_from}{date_from}

\item{date_to}{date_to}

\item{division}{division}

\item{game_segment}{game_segment}

\item{group_quantity}{group_quantity}

\item{last_n_games}{last_n_games}

\item{league_id}{league_id}

\item{location}{location}

\item{measure_type}{measure_type}

\item{minutes_min}{minutes_min}

\item{month}{month}

\item{opponent_team_id}{opponent_team_id}

\item{outcome}{outcome}

\item{po_round}{po_round}

\item{pace_adjust}{pace_adjust}

\item{per_mode}{per_mode}

\item{period}{period}

\item{plus_minus}{plus_minus}

\item{rank}{rank}

\item{season}{season}

\item{season_segment}{season_segment}

\item{season_type}{season_type}

\item{shot_clock_range}{shot_clock_range}

\item{team_id}{team_id}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: LeagueLineupViz

\strong{LeagueLineupViz}\tabular{ll}{
   col_name \tab types \cr
   GROUP_ID \tab character \cr
   GROUP_NAME \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   MIN \tab character \cr
   OFF_RATING \tab character \cr
   DEF_RATING \tab character \cr
   NET_RATING \tab character \cr
   PACE \tab character \cr
   TS_PCT \tab character \cr
   FTA_RATE \tab character \cr
   TM_AST_PCT \tab character \cr
   PCT_FGA_2PT \tab character \cr
   PCT_FGA_3PT \tab character \cr
   PCT_PTS_2PT_MR \tab character \cr
   PCT_PTS_FB \tab character \cr
   PCT_PTS_FT \tab character \cr
   PCT_PTS_PAINT \tab character \cr
   PCT_AST_FGM \tab character \cr
   PCT_UAST_FGM \tab character \cr
   OPP_FG3_PCT \tab character \cr
   OPP_EFG_PCT \tab character \cr
   OPP_FTA_RATE \tab character \cr
   OPP_TOV_PCT \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API League Lineup Visual Data}

\strong{Get WNBA Stats API League Lineup Visual Data}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{  wnba_leaguelineupviz(league_id = '10', season = most_recent_wnba_season() - 1)
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA League Functions: 
\code{\link{wnba_leaguedashlineups}()},
\code{\link{wnba_leaguedashplayerbiostats}()},
\code{\link{wnba_leaguedashplayerclutch}()},
\code{\link{wnba_leaguedashplayershotlocations}()},
\code{\link{wnba_leaguedashplayerstats}()},
\code{\link{wnba_leaguedashteamclutch}()},
\code{\link{wnba_leaguedashteamshotlocations}()},
\code{\link{wnba_leaguedashteamstats}()},
\code{\link{wnba_leaguegamefinder}()},
\code{\link{wnba_leaguegamelog}()},
\code{\link{wnba_leagueplayerondetails}()},
\code{\link{wnba_leagueseasonmatchups}()},
\code{\link{wnba_leaguestandingsv3}()},
\code{\link{wnba_shotchartleaguewide}()}

Other WNBA Lineup Functions: 
\code{\link{wnba_gamerotation}()},
\code{\link{wnba_leaguedashlineups}()},
\code{\link{wnba_shotchartlineupdetail}()},
\code{\link{wnba_teamdashlineups}()}
}
\author{
Saiem Gilani
}
\concept{WNBA League Functions}
\concept{WNBA Lineup Functions}
