% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/espn_wnba_data.R
\name{espn_wnba_team_stats}
\alias{espn_wnba_team_stats}
\title{\strong{Get ESPN WNBA team stats data}}
\usage{
espn_wnba_team_stats(team_id, year, season_type = "regular", total = FALSE)
}
\arguments{
\item{team_id}{Team ID}

\item{year}{Year}

\item{season_type}{(character, default: regular): Season type - regular or postseason}

\item{total}{(boolean, default: FALSE): Totals}
}
\value{
Returns a tibble with the team stats data\tabular{ll}{
   col_name \tab types \cr
   team_id \tab integer \cr
   team_guid \tab character \cr
   team_uid \tab character \cr
   team_sdr \tab integer \cr
   team_slug \tab character \cr
   team_location \tab character \cr
   team_name \tab character \cr
   team_abbreviation \tab character \cr
   team_display_name \tab character \cr
   team_short_display_name \tab character \cr
   team_color \tab character \cr
   team_alternate_color \tab character \cr
   team_is_active \tab logical \cr
   team_is_all_star \tab logical \cr
   logo_href \tab character \cr
   logo_dark_href \tab character \cr
   defensive_blocks \tab numeric \cr
   defensive_defensive_rebounds \tab numeric \cr
   defensive_steals \tab numeric \cr
   defensive_avg_defensive_rebounds \tab numeric \cr
   defensive_avg_blocks \tab numeric \cr
   defensive_avg_steals \tab numeric \cr
   defensive_avg48defensive_rebounds \tab numeric \cr
   defensive_avg48blocks \tab numeric \cr
   defensive_avg48steals \tab numeric \cr
   general_disqualifications \tab numeric \cr
   general_flagrant_fouls \tab numeric \cr
   general_fouls \tab numeric \cr
   general_ejections \tab numeric \cr
   general_technical_fouls \tab numeric \cr
   general_rebounds \tab numeric \cr
   general_avg_minutes \tab numeric \cr
   general_nba_rating \tab numeric \cr
   general_plus_minus \tab numeric \cr
   general_game_day_of_year \tab numeric \cr
   general_avg_rebounds \tab numeric \cr
   general_avg_fouls \tab numeric \cr
   general_avg_flagrant_fouls \tab numeric \cr
   general_avg_technical_fouls \tab numeric \cr
   general_avg_ejections \tab numeric \cr
   general_avg_disqualifications \tab numeric \cr
   general_assist_turnover_ratio \tab numeric \cr
   general_steal_foul_ratio \tab numeric \cr
   general_block_foul_ratio \tab numeric \cr
   general_avg_team_rebounds \tab numeric \cr
   general_total_rebounds \tab numeric \cr
   general_total_technical_fouls \tab numeric \cr
   general_team_assist_turnover_ratio \tab numeric \cr
   general_team_rebounds \tab numeric \cr
   general_steal_turnover_ratio \tab numeric \cr
   general_avg48rebounds \tab numeric \cr
   general_avg48fouls \tab numeric \cr
   general_avg48flagrant_fouls \tab numeric \cr
   general_avg48technical_fouls \tab numeric \cr
   general_avg48ejections \tab numeric \cr
   general_avg48disqualifications \tab numeric \cr
   general_games_played \tab numeric \cr
   general_games_started \tab numeric \cr
   general_double_double \tab numeric \cr
   general_triple_double \tab numeric \cr
   offensive_assists \tab numeric \cr
   offensive_field_goals \tab numeric \cr
   offensive_field_goals_attempted \tab numeric \cr
   offensive_field_goals_made \tab numeric \cr
   offensive_field_goal_pct \tab numeric \cr
   offensive_free_throws \tab numeric \cr
   offensive_free_throw_pct \tab numeric \cr
   offensive_free_throws_attempted \tab numeric \cr
   offensive_free_throws_made \tab numeric \cr
   offensive_offensive_rebounds \tab numeric \cr
   offensive_points \tab numeric \cr
   offensive_turnovers \tab numeric \cr
   offensive_three_point_pct \tab numeric \cr
   offensive_three_point_field_goals_attempted \tab numeric \cr
   offensive_three_point_field_goals_made \tab numeric \cr
   offensive_team_turnovers \tab numeric \cr
   offensive_total_turnovers \tab numeric \cr
   offensive_points_in_paint \tab numeric \cr
   offensive_brick_index \tab numeric \cr
   offensive_avg_field_goals_made \tab numeric \cr
   offensive_avg_field_goals_attempted \tab numeric \cr
   offensive_avg_three_point_field_goals_made \tab numeric \cr
   offensive_avg_three_point_field_goals_attempted \tab numeric \cr
   offensive_avg_free_throws_made \tab numeric \cr
   offensive_avg_free_throws_attempted \tab numeric \cr
   offensive_avg_points \tab numeric \cr
   offensive_avg_points_allowed \tab numeric \cr
   offensive_avg_offensive_rebounds \tab numeric \cr
   offensive_avg_assists \tab numeric \cr
   offensive_avg_turnovers \tab numeric \cr
   offensive_offensive_rebound_pct \tab numeric \cr
   offensive_estimated_possessions \tab numeric \cr
   offensive_avg_estimated_possessions \tab numeric \cr
   offensive_points_per_estimated_possessions \tab numeric \cr
   offensive_avg_team_turnovers \tab numeric \cr
   offensive_avg_total_turnovers \tab numeric \cr
   offensive_three_point_field_goal_pct \tab numeric \cr
   offensive_two_point_field_goals_made \tab numeric \cr
   offensive_two_point_field_goals_attempted \tab numeric \cr
   offensive_avg_two_point_field_goals_made \tab numeric \cr
   offensive_avg_two_point_field_goals_attempted \tab numeric \cr
   offensive_two_point_field_goal_pct \tab numeric \cr
   offensive_shooting_efficiency \tab numeric \cr
   offensive_scoring_efficiency \tab numeric \cr
   offensive_avg48field_goals_made \tab numeric \cr
   offensive_avg48field_goals_attempted \tab numeric \cr
   offensive_avg48three_point_field_goals_made \tab numeric \cr
   offensive_avg48three_point_field_goals_attempted \tab numeric \cr
   offensive_avg48free_throws_made \tab numeric \cr
   offensive_avg48free_throws_attempted \tab numeric \cr
   offensive_avg48points \tab numeric \cr
   offensive_avg48offensive_rebounds \tab numeric \cr
   offensive_avg48assists \tab numeric \cr
   offensive_avg48turnovers \tab numeric \cr
}
}
\description{
\strong{Get ESPN WNBA team stats data}
}
\examples{
\donttest{
  try(espn_wnba_team_stats(team_id = 18, year = 2020))
}
}
\seealso{
Other ESPN WNBA Functions: 
\code{\link{espn_wnba_game_all}()},
\code{\link{espn_wnba_game_rosters}()},
\code{\link{espn_wnba_pbp}()},
\code{\link{espn_wnba_player_box}()},
\code{\link{espn_wnba_player_stats}()},
\code{\link{espn_wnba_scoreboard}()},
\code{\link{espn_wnba_standings}()},
\code{\link{espn_wnba_team_box}()},
\code{\link{espn_wnba_teams}()}
}
\author{
Saiem Gilani
}
\concept{ESPN WNBA Functions}
\keyword{Stats}
\keyword{Team}
\keyword{WNBA}
