% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_stim.R
\name{write_stim}
\alias{write_stim}
\title{Write images and templates to files}
\usage{
write_stim(
  stimuli,
  dir = ".",
  names = NULL,
  format = "png",
  ...,
  overwrite = wm_opts("overwrite")
)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{dir}{Directory to save to}

\item{names}{A vector of stimulus names or NULL to use names from the stimuli list}

\item{format}{output format such as "png", "jpeg", "gif"; is overridden if names end in .png, .jpg, or .gif}

\item{...}{other arguments to pass to \link[magick:editing]{magick::image_write}, such as quality (for jpegs)}

\item{overwrite}{whether to overwrite existing files (TRUE/FALSE) or "ask" (only in interactive mode)}
}
\value{
list of saved paths
}
\description{
Write images and templates to files
}
\examples{
\dontrun{
# write demo stim as jpegs to directory ./test_faces
demo_stim() |> 
  write_stim("test_faces", format = "jpg")
}
}
\seealso{
Stimulus creating functions
\code{\link{animate}()},
\code{\link{as_stimlist}()},
\code{\link{blank}()},
\code{\link{new_stimlist}()},
\code{\link{new_stim}()},
\code{\link{read_img}()},
\code{\link{read_stim}()},
\code{\link{read_tem}()}
}
\concept{stim}
