% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Acf.R
\name{acf.gamma_m}
\alias{acf.gamma_m}
\title{Computation of autocovariance and autocorrelation for an ARMA residuals.}
\usage{
acf.gamma_m(ar = NULL, ma = NULL, y, h, e = NULL)
}
\arguments{
\item{ar}{Vector of AR coefficients. If \code{NULL},  it is a MA process.}

\item{ma}{Vector of MA coefficients. If \code{NULL},  it is a AR process.}

\item{y}{Univariate time series.}

\item{h}{Computes autocovariances and autocorrelations from lag 1 to lag h with h an integer.}

\item{e}{Vector of residuals. If \code{NULL}, the function will compute it.}
}
\value{
A list with :
\describe{
    \item{\code{gamma_m}}{Vector of the autocovariances.}
    \item{\code{rho_m}}{Vector of the autocorrelations.}
}
}
\description{
Computes empirical autocovariances and autocorrelations function
 for an ARMA process for lag max given.
}
\examples{
param.estim <- estimation(p = 1,  q = 1, y = CAC40return.sq)
\donttest{acf.gamma_m(ar = param.estim$ar, ma = param.estim$ma, y = CAC40return.sq,  h = 20)}

}
\seealso{
\code{\link{acf.univ}} for autocorrelation and autocovariance for only one given lag h.
}
