% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cls_wdnet.R
\name{create_wdnet}
\alias{create_wdnet}
\title{Creates a \code{wdnet} object from input data.}
\usage{
create_wdnet(
  netwk,
  edgelist,
  edgeweight,
  nodegroup,
  directed,
  adj,
  weighted,
  ...
)
}
\arguments{
\item{netwk}{A \code{wdnet} object. If \code{NULL}, the function will use the
provided \code{edgelist} and \code{edgeweight}, or \code{adj} parameters to
create a new \code{wdnet} object.}

\item{edgelist}{A two-column matrix representing edges.}

\item{edgeweight}{A vector representing the weights of the edges.}

\item{nodegroup}{A numeric vector of node groups.}

\item{directed}{A logical value indicating whether the network is directed.
Required if \code{netwk} is \code{NULL}.}

\item{adj}{An adjacency matrix.}

\item{weighted}{A logical value indicating whether the network is weighted.}

\item{...}{Additional components to be added to the wdnet list.}
}
\value{
A \code{wdnet} object.
}
\description{
This function creates a \code{wdnet} object from \code{edgelist} and
\code{edgeweight} or \code{adj} or returns the existing \code{wdnet} object.
For internal usage.
}
\keyword{internal}
