% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indep_test.R
\name{indep_test}
\alias{indep_test}
\title{Independence Tests for Weighted Dependence Measures}
\usage{
indep_test(x, y, method = "pearson", weights = NULL,
  remove_missing = TRUE, alternative = "two-sided")
}
\arguments{
\item{x, y}{numeric vectors of data values. \code{x} and \code{y} must have the same
length.}

\item{method}{the dependence measure; see \emph{Details} for possible values.}

\item{weights}{an optional vector of weights for the observations.}

\item{remove_missing}{if \code{TRUE}, all (pairwise) incomplete observations are
removed; if \code{FALSE}, the function throws an error if there are incomplete
observations.}

\item{alternative}{indicates the alternative hypothesis and must be one of
\code{"two-sided"}, \code{"greater"} or \code{"less"}. You can specify just the initial
letter. \code{"greater"} corresponds to positive association, \code{"less"} to
negative association.}
}
\description{
Computes a (possibly weighted) dependence measure between \code{x} and \code{y} if
these are vectors. If \code{x} and \code{y} are matrices then the measure between the
columns of \code{x} and the columns of \code{y} are computed.
}
\details{
Available methods:
\itemize{
\item \code{"pearson"}: Pearson correlation
\item \code{"spearman"}: Spearman's \eqn{\rho}
\item \code{"kendall"}: Kendall's \eqn{\tau}
\item \code{"blomqvist"}: Blomqvist's \eqn{\beta}
\item \code{"hoeffding"}: Hoeffding's \eqn{D}
}

Partial matching of method names is enabled.
All methods except \code{"hoeffding"} work with discrete variables.
}
\examples{
x <- rnorm(100)
y <- rpois(100, 1)  # all but Hoeffding's D can handle ties
w <- runif(100)

indep_test(x, y, method = "kendall")               # unweighted
indep_test(x, y, method = "kendall", weights = w)  # weighted

}
