% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wcde.R
\name{get_wcde}
\alias{get_wcde}
\title{Download data from the Wittgenstein Centre Human Capital Data Explorer}
\usage{
get_wcde(
  indicator = "pop",
  scenario = 2,
  country_code = NULL,
  country_name = NULL,
  pop_age = c("total", "all"),
  pop_sex = c("total", "both", "all"),
  pop_edu = c("total", "four", "six", "eight"),
  include_scenario_names = FALSE
)
}
\arguments{
\item{indicator}{One character string based on the \code{indicator} column in the \code{wic_indicators} data frame, representing the variable to be downloaded.}

\item{scenario}{Vector of length one or more with numbers corresponding the scenarios. See details for more information. Defaults to 2 for the SSP2 Medium scenario.}

\item{country_code}{Vector of length one or more of country numeric codes based on ISO 3 digit numeric values.}

\item{country_name}{Vector of length one or more of country names. The corresponding country code will be guessed using the countrycodes package.}

\item{pop_age}{Character string for population age groups if \code{indicator} is set to \code{pop}. Defaults to no age groups \code{total}, but can be set to \code{all}.}

\item{pop_sex}{Character string for population sexes if \code{indicator}is set to \code{pop}. Defaults to no sex \code{total}, but can be set to \code{both} or \code{all}.}

\item{pop_edu}{Character string for population educational attainment if \code{indicator} is set to \code{pop}. Defaults to \code{total}, but can be set to \code{four}, \code{six} or \code{eight}.}

\item{include_scenario_names}{Logical vector of length one to indicate if to include additional columns for scenario names and short names. \code{FALSE} by default.}
}
\value{
A \link[tibble:tibble-package]{tibble} with the data selected.
}
\description{
Downloads data from the Wittgenstein Centre Human Capital Data Explorer. Requires a working internet connection.
}
\details{
If not \code{country_name} or \code{country_code} is provided data for all countries and regions are downloaded. A full list of available countries and regions can be found in the \code{wic_locations} data frame.

\code{indicator} must be set to a value in the first column in the table below of available demographic indicators:\tabular{ll}{
   \code{indicator} \tab Indicator Description \cr
   \code{pop} \tab Population Size (000's) \cr
   \code{bpop} \tab Population Size by Broad Age (000's) \cr
   \code{epop} \tab Population Size by Education (000's) \cr
   \code{prop} \tab Educational Attainment Distribution \cr
   \code{bprop} \tab Educational Attainment Distribution by Broad Age \cr
   \code{growth} \tab Average Annual Growth Rate \cr
   \code{nirate} \tab Average Annual Rate of Natural Increase \cr
   \code{sexratio} \tab Sex Ratio \cr
   \code{mage} \tab Population Median Age \cr
   \code{tdr} \tab Total Dependency Ratio \cr
   \code{ydr} \tab Youth Dependency Ratio \cr
   \code{odr} \tab Old-age Dependency Ratio \cr
   \code{ryl15} \tab Age When Remaining Life Expectancy is Below 15 years \cr
   \code{pryl15} \tab Proportion of Population with a Remaining Life Expectancy below 15 Years \cr
   \code{mys} \tab Mean Years of Schooling by Age \cr
   \code{bmys} \tab Mean Years of Schooling by Broad Age \cr
   \code{ggapmys15} \tab Gender Gap in Mean Years Schooling (15+) \cr
   \code{ggapmys25} \tab Gender Gap in Mean Years Schooling (25+) \cr
   \code{ggapedu15} \tab Gender Gap in Educational Attainment (15+) \cr
   \code{ggapedu25} \tab Gender Gap in Educational Attainment (25+) \cr
   \code{tfr} \tab Total Fertility Rate \cr
   \code{etfr} \tab Total Fertility Rate by Education \cr
   \code{asfr} \tab Age-Specific Fertility Rate \cr
   \code{easfr} \tab Age-Specific Fertility Rate by Education \cr
   \code{cbr} \tab Crude Birth Rate \cr
   \code{macb} \tab Mean Age at Childbearing \cr
   \code{e0} \tab Life Expectancy at Birth \cr
   \code{cdr} \tab Crude Death Rate \cr
   \code{assr} \tab Age-Specific Survival Ratio \cr
   \code{eassr} \tab Age-Specific Survival Ratio by Education \cr
   \code{net} \tab Net Migration \cr
}


See \code{wic_indicators} data frame for more details.

\code{scenario} must be set to one or values in the first column table below of the available future scenarios:\tabular{ll}{
   \code{scenario} \tab description \cr
   \code{1} \tab Rapid Development (SSP1) \cr
   \code{2} \tab Medium (SSP2) \cr
   \code{3} \tab Stalled Development (SSP3) \cr
   \code{21} \tab Medium - Zero Migration (SSP2 - ZM) \cr
   \code{22} \tab Medium - Double Migration (SSP2 - DM) \cr
}


See \code{wic_scenarios} data frame for more details.
}
\examples{
\donttest{
# SSP2 tfr for Austria and Bulgaria
get_wcde(indicator = "tfr", country_code = c(40, 100))

# SSP1 and SSP2 life expectancy for Vietnam and United Kingdom (guessing the country codes)
get_wcde(scenario = c(1, 2), indicator = "e0", country_name = c("Vietnam", "UK"))

# SSP1 and SSP3 population by education for all countries
get_wcde(scenario = c(1, 3), indicator = "tfr")

# population totals (aggregated over age and sex)
get_wcde(indicator = "pop", country_name = "Austria")

# population education group totals
get_wcde(indicator = "pop", country_name = "Austria", pop_edu = "four")

# population age-sex group totals
get_wcde(indicator = "pop", country_name = "Austria", pop_age = "all", pop_sex = "both")
}
}
