% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestModelPerformance.R
\name{TestModelPerformance}
\alias{TestModelPerformance}
\title{Test the performance of spectral models}
\usage{
TestModelPerformance(
  train.data,
  num.iterations,
  test.data = NULL,
  preprocessing = TRUE,
  wavelengths = 740:1070,
  tune.length = 50,
  model.method = "pls",
  output.summary = TRUE,
  rf.variable.importance = FALSE,
  stratified.sampling = TRUE,
  cv.scheme = NULL,
  trial1 = NULL,
  trial2 = NULL,
  trial3 = NULL,
  split.test = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{train.data}{\code{data.frame} object of spectral data for input into a
spectral prediction model. First column contains unique identifiers, second
contains reference values, followed by spectral columns. Include no other
columns to right of spectra! Column names of spectra must start with "X"
and reference column must be named "reference".}

\item{num.iterations}{Number of training iterations to perform}

\item{test.data}{\code{data.frame} with same specifications as \code{df}. Use
if specific test set is desired for hyperparameter tuning. If \code{NULL},
function will automatically train with a stratified sample of 70\%. Default
is \code{NULL}.}

\item{preprocessing}{If \code{TRUE}, 12 preprocessing methods will be applied
and their performance analyzed. If \code{FALSE}, input data is analyzed as
is (raw). Default is \code{FALSE}.}

\item{wavelengths}{List of wavelengths represented by each column in
\code{train.data}}

\item{tune.length}{Number delineating search space for tuning of the PLSR
hyperparameter \code{ncomp}. Default is 50.}

\item{model.method}{Model type to use for training. Valid options include:
\itemize{ \item "pls": Partial least squares regression (Default) \item
"rf": Random forest \item "svmLinear": Support vector machine with linear
kernel \item "svmRadial": Support vector machine with radial kernel }}

\item{output.summary}{boolean that controls function output. \itemize{ \item
If \code{TRUE}, a summary df will be output (1st row = means, 2nd row =
standard deviations). Default is \code{TRUE}. \item If \code{FALSE}, entire
results data frame will be output }}

\item{rf.variable.importance}{boolean that: \itemize{ \item If \code{TRUE},
\code{model.method} must be set to "rf". Returns a list with a model
performance \code{data.frame} and a second \code{data.frame} with variable
importance values for each wavelength for each training iteration. If
\code{return.model} is also \code{TRUE}, returns list of three elements
with trained model first, model performance second, and variable importance
last. Dimensions are \code{nrow = num.iterations}, \code{ncol =
length(wavelengths)}. \item If \code{FALSE}, no variable importance is
returned. Default is \code{FALSE}. }}

\item{stratified.sampling}{If \code{TRUE}, training and test sets will be
selected using stratified random sampling. This term is only used if
\code{test.data == NULL}. Default is \code{TRUE}.}

\item{cv.scheme}{A cross validation (CV) scheme from Jarquín et al., 2017.
Options for cv.scheme include:
\itemize{
    \item "CV1": untested lines in tested environments
    \item "CV2": tested lines in tested environments
    \item "CV0": tested lines in untested environments
    \item "CV00": untested lines in untested environments
}}

\item{trial1}{\code{data.frame} object that is for use only when
\code{cv.scheme} is provided. Contains the trial to be tested in subsequent
model training functions. The first column contains unique identifiers,
second contains genotypes, third contains reference values, followed by
spectral columns. Include no other columns to right of spectra! Column
names of spectra must start with "X", reference column must be named
"reference", and genotype column must be named "genotype".}

\item{trial2}{\code{data.frame} object that is for use only when
\code{cv.scheme} is provided. This data.frame contains a trial that has
overlapping genotypes with \code{trial1} but that were grown in a different
site/year (different environment). Formatting must be consistent with
\code{trial1}.}

\item{trial3}{\code{data.frame} object that is for use only when
\code{cv.scheme} is provided. This data.frame contains a trial that may or
may not contain genotypes that overlap with \code{trial1}. Formatting must
be consistent with \code{trial1}.}

\item{split.test}{boolean that allows for a fixed training set and a split
test set. Example// train model on data from two breeding programs and a
stratified subset (70\%) of a third and test on the remaining samples
(30\%)  of the third. If \code{FALSE}, the entire provided test set
\code{test.data} will remain as a testing set or if none is provided, 30\%
of the provided \code{train.data} will be used for testing. Default is
\code{FALSE}.}

\item{verbose}{If \code{TRUE}, the number of rows removed through filtering
will be printed to the console. Default is \code{TRUE}.}
}
\value{
\code{data.frame} with model performance statistics in summary format
  (2 rows, one with mean and one with standard deviation of all training
  iterations) or in long format (number of rows = num.iterations).
  \strong{Note} if \code{preprocessing = TRUE}, only the first mean of
  summary statistics for all iterations of training are provided for each
  technique.
Included summary statistics:
\itemize{
  \item Tuned parameters depending on the model algorithm:
  \itemize{
    \item \strong{Best.n.comp}, the best number of components
    \item \strong{Best.ntree}, the best number of trees in an RF model
    \item \strong{Best.mtry}, the best number of variables to include at every decision point in an RF model
    }
  \item \strong{RMSECV}, the root mean squared error of cross-validation
  \item \strong{R2cv}, the coefficient of multiple determination of cross-validation for PLSR models
  \item \strong{RMSEP}, the root mean squared error of prediction
  \item \strong{R2p}, the squared Pearson’s correlation between predicted and observed test set values
  \item \strong{RPD}, the ratio of standard deviation of observed test set values to RMSEP
  \item \strong{RPIQ}, the ratio of performance to interquartile difference
  \item \strong{CCC}, the concordance correlation coefficient
  \item \strong{Bias}, the average difference between the predicted and observed values
  \item \strong{SEP}, the standard error of prediction
  \item \strong{R2sp}, the squared Spearman’s rank correlation between predicted and observed test set values
}
}
\description{
Wrapper that trains models based spectral data to predict
  reference values and reports model performance statistics
}
\details{
Calls \code{\link{DoPreprocessing}}, \code{\link{FormatCV}},
and \code{\link{TrainSpectralModel}} functions.
}
\examples{
\donttest{
library(magrittr)
ikeogu.2017 \%>\%
  dplyr::rename(reference = DMC.oven) \%>\%
  dplyr::rename(unique.id = sample.id) \%>\%
  dplyr::select(unique.id, reference, dplyr::starts_with("X")) \%>\%
  na.omit() \%>\%
  TestModelPerformance(train.data = .,
                       tune.length = 3,
                       num.iterations = 3,
                       preprocessing = FALSE,
                       wavelengths = 350:2500)
}
}
\author{
Jenna Hershberger \email{jmh579@cornell.edu}
}
