% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveformclip.R
\name{waveformclip}
\alias{waveformclip}
\title{waveformclip}
\usage{
waveformclip(waveform, geo, shp, geoextent = c())
}
\arguments{
\item{waveform}{The raw waveform data containing intensities and index of waveform.}

\item{geo}{The reference geolocation that corresponds to the raw waveform data which has the same number of rows as the waveform data.}

\item{shp}{The region of interst which tells the regions to clip, it require has the same projetct coordinate system (UTM is prefered) as the geo data.}

\item{geoextent}{Another way to clip waveform using xmin, xmax, ymin, ymax. Please note you should specify the parameter in this order. Defalut is NULL.}
}
\value{
For using shapefile, it will return a dataframe with shapefile index (this will be useful for multipolygons) and corresponding select waveforms in each sub shapefiles.
  For the geoextent, it will return the selected waveforms in the extent and corresponind selected index of geo data.
}
\description{
The function allows you to select waveforms of your interest from the whole waveform dataset based on the shpfile(s) or
  geoextent including xmin,xmax,ymin,ymax.
}
\examples{

data(return)  ###import raw return waveforms
data(geo)  ###import corresponding reference geolocation
data(shp_hf)  ###import shpefile
##the next step is required, since everybody's georeference data maybe
##a bit difference, you need to adjust by yourself when you implement the function.

### you need to assign x and y columns at least to make the function run properly
colnames(geo)[2:9]<-c("x","y","z","dx","dy","dz","or","fr")

##use shp file
##this step is required. Mainly to identify index of selected waveforms from original datasets
waveform<-cbind(waveformindex=1:nrow(return),return)
geo<-geo
shp<-shp_hf
swre<-waveformclip(waveform,geo,shp)

###use geoextent
swre1<-waveformclip(waveform,geo,geoextent=c(731126,731128,4712678,4712698))
}
