% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ground.location.R
\name{ground.location}
\alias{ground.location}
\title{ground.location}
\usage{
ground.location(y, smooth = TRUE, rescale = TRUE, thres = 0.2,
  width = 3, top = TRUE)
}
\arguments{
\item{y}{is the waveform intensities. If you have other information, you should delete these intensites before you run this function .}

\item{smooth}{is tell whether you want to smooth the waveform to reduce the effect of some obvious noise. Default is TRUE.}

\item{rescale}{is to determine whether you want to rescale the waveform intensity or not. Here we used the minimum intensity of each waveform to conduct rescaling.
Default is using rescaling.}

\item{thres}{is to determine if the detected peak is the real peak. The real peak's intensity should be higher than threshold*maximum intensity. Default is 0.22.}

\item{width}{the width of moving window for smoothing.Default is 3, must be integer between 1 and n.This parameter ONLY work when the smooth is TRUE.}

\item{top}{is to tell whether we calculate the ground time location from the top (where waveform starts or canopy) or from the bottom (where the waveform ends). Default is from the top.}
}
\value{
return the index of possible ground position of waveform.
}
\description{
The function allows you to identify the possible ground location (time index) in the waveform. Generally, we assume the last echo or peak corresponding to the ground.
}
\examples{

data(return)
x<-return[125,]
#default
ground.location(x)

}
