% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water_ET.R
\name{dailyET}
\alias{dailyET}
\title{Calculates daily ET using Penman Monteith hourly formula for every hour}
\usage{
dailyET(WeatherStation, DOY, height, lat, long, elev, ET = "ETr",
  long.z = WeatherStation$long, date = "auto", MTL)
}
\arguments{
\item{WeatherStation}{a data frame with all the needed fields (see example)}

\item{DOY}{day of year}

\item{height}{weather station sensors height in meters}

\item{lat}{latitude in decimal degrees of the weather station}

\item{long}{longitude in decimal degrees of the weather station}

\item{elev}{elevation in meters of the weather station}

\item{ET}{"ETo" for short crops, similar to clipped, cool-season
grass; or "ETr" for tall crops, similar to 0.5 m tall full-cover alfalfa.}

\item{long.z}{longitude for local time}

\item{date}{if date == "auto" will use a MTL file provided or present in 
the working folder to select the date.}

\item{MTL}{Metadata file. If not provided will look for one on
working directory. If provided or present will calculate weather conditions
on satellite overpass.}
}
\value{
ET      daily in mm.h-1
}
\description{
Calculates daily ET using Penman Monteith hourly formula for every hour
}
\examples{
csvfile <- system.file("extdata", "apples.csv", package="water")

WeatherStation <- read.WSdata(WSdata = csvfile, date.format = "\%d/\%m/\%Y", 
lat=-35.42222, long= -71.38639, elev=201, height= 2.2, cf=c(1,0.2777778,1,1))

dailyET(WeatherStation = WeatherStation, lat=-35.422, long=-71.386, elev=124, 
ET="ETo")

}
\references{
Allen 2005 ASCE
}
\author{
Guillermo Federico Olmedo
}
