% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water_netRadiation.G.R
\name{albedo}
\alias{albedo}
\title{Calculates Broadband Albedo from Landsat data}
\usage{
albedo(image.SR, aoi, coeff = "Tasumi", sat = "auto")
}
\arguments{
\item{image.SR}{surface reflectance image with bands B, R, G, NIR, SWIR1, 
SWIR2}

\item{aoi}{area of interest to crop images, if waterOptions("autoAoi")
== TRUE will look for any object called aoi on .GlobalEnv}

\item{coeff}{coefficient to transform narrow to broad band albedo. 
See Details.}

\item{sat}{"L7" for Landsat 7, "L8" for Landsat 8 or "auto" to guess 
from filenames}
}
\description{
Broadband surface Albedo is estimated considering the integration of all 
narrowband at-surface reflectances following a weighting function with 
empirical coefficients (Tasumi et al., 2007).
}
\details{
There are differents models to convert narrowband data to broadband albedo. 
You can choose coeff="Tasumi" to use Tasumi et al (2008) coefficients, 
calculated for Landsat 7; coeff="Liang" to use Liang Landsat 7 coefficients 
or "Olmedo" to use Olmedo coefficients for Landsat 8.
}
\references{
R. G. Allen, M. Tasumi, and R. Trezza, "Satellite-based energy balance for mapping evapotranspiration with internalized calibration (METRIC) - Model" Journal of Irrigation and Drainage Engineering, vol. 133, p. 380, 2007 \cr
M. Tasumi, Allen, R. G., and Trezza, R. 2007. "Estimation of at-surface reflection albedo from satellite for routine operational calculation of land surface energy balance". J. Hydrol. Eng. \cr
Liang, S. (2000). Narrowband to broadband conversions of land surface albedo: I. Algorithms. Remote Sensing of Environment, 76(1), 213-238. \cr
}
\seealso{
Other net radiation related functions: \code{\link{LAI}},
  \code{\link{METRICtopo}}, \code{\link{SWtrasmisivity}},
  \code{\link{incLWradiation}},
  \code{\link{incSWradiation}}, \code{\link{netRadiation}},
  \code{\link{outLWradiation}}, \code{\link{soilHeatFlux}},
  \code{\link{solarAngles}},
  \code{\link{surfaceTemperature}}
}
\author{
Guillermo Federico Olmedo

Fonseca-Luengo, David
}
