% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_clipping.R
\name{find_clipping}
\alias{find_clipping}
\title{Find clipped selections}
\usage{
find_clipping(X, path = NULL, parallel = 1, pb = TRUE)
}
\arguments{
\item{X}{'selection_table', 'extended_selection_table' or data frame with the following columns: 1) "sound.files": name of the sound
files, 2) "selec": number of the selections, 3) "start": start time of selections, 4) "end":
end time of selections.}

\item{path}{Character string containing the directory path where the sound files are located.
If \code{NULL} (default) then the current working directory is used.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control progress bar and messages. Default is \code{TRUE}.}
}
\value{
A data frame with the 'sound.files' and 'selec' columns in X plus an additional column ('prop.clipped') indicating
the proportion of clipped samples for each row. If sound files are stereo the average proportion of the two channels is returned.
}
\description{
\code{find_clipping} gets the proportion of samples that are clipped.
}
\details{
Clipping (i.e. saturation) occurs when an audio signal is amplified above the maximum limit of the recorder. This leads to distortion and a lowering of audio quality. If stereo the mean proportion of both channels is returned. The function assumes specific range values for different bit depths as detailed in \code{\link[tuneR]{normalize}}.
}
\examples{
{
  # load data
  data(list = c("Phae.long1", "Phae.long2", "lbh_selec_table"))
  writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav")) # save sound files
  writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))

  find_clipping(X = lbh_selec_table[1:5, ], path = tempdir())
}
}
\references{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
\seealso{
\code{\link{sig2noise}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
