% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/querxc.R
\name{querxc}
\alias{querxc}
\title{Access Xeno-Canto recordings and metadata}
\usage{
querxc(qword, download = FALSE)
}
\arguments{
\item{qword}{Character vector of length one indicating the genus, or genus and
species, to query Xeno-Canto database. For example, \emph{Phaethornis} or \emph{Phaethornis longirostris}.
(\url{http://www.xeno-canto.org/}).}

\item{download}{Logical argument. Downloads recording file names and
associated metadata if \code{FALSE}. If \code{TRUE}, recordings are also downloaded to working
directory as .mp3 files. Default is \code{FALSE}.}
}
\value{
Data frame with recording information and .mp3 files (if download = \code{TRUE}).
}
\description{
\code{querxc} downloads recordings and metadata from Xeno-Canto (\url{http://www.xeno-canto.org/}).
}
\examples{
\dontrun{
# First create empty folder
dir.create(file.path(getwd(),"temp"))
setwd(file.path(getwd(),"temp"))
df1 <- querxc("Phaethornis anthophilus", download = FALSE)
View(df1)

#downloading files
querxc("Phaethornis anthophilus", download = TRUE)
#check this folder!!
getwd()

# remove example directory
unlink(getwd(),recursive = TRUE)
}
}
\author{
Marcelo Araya-Salas (\url{http://marceloarayasalas.weebly.com/}) and Hua Zhong
}

