% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/autodetec_1.0.R
\name{autodetec}
\alias{autodetec}
\title{Automatically detect vocalizations in sound files}
\usage{
autodetec(X= NULL, threshold=15, envt="abs", msmooth=c(300,90),
  power=1, bp=NULL, osci = FALSE, wl = 512, xl = 1, picsize = 1, res = 100,
  flim = c(0,22), ls = FALSE, sxrow = 10, rows = 10, mindur = NULL, maxdur =
  NULL, redo = FALSE, img = T, it = "jpeg", set = F, flist = NULL)
}
\arguments{
\item{X}{Data frame output from manualoc().}

\item{threshold}{A number specifying the amplitude threshold for detecting
signals (in percentage).}

\item{envt}{Character vector of length one specifying the type of envelope to
be used: "abs" for absolute amplitude envelope or "hil" for Hilbert
amplitude envelope. Default is "abs".}

\item{msmooth}{A numeric vector of length 2 to smooth the amplitude envelope
with a mean sliding window. The first component is the window length and
the second is the overlap between successive windows (in \%).}

\item{power}{A numeric vector of length 1 indicating a power factor applied
to the amplitude envelope. Increasing power will reduce low amplitude
modulations and increase high amplide modulations, in order to reduce
background noise. Default is 1 (no change).}

\item{bp}{Numeric vector of length two giving the lower and upper limits of a
frequency bandpass filter (in kHz). Default is c(0, 22).}

\item{osci}{Logical argument to add an oscillogram underneath spectrogram, as
in \code{\link[seewave]{spectro}}. Default is FALSE. Not applied if ls is
TRUE.}

\item{wl}{A number specifying the window length of the spectrogram, default
is 512.}

\item{xl}{Numeric vector of length one, a constant by which to scale
spectrogram width. Default is 1.}

\item{picsize}{Numeric argument of length one, controls relative size of
spectrogram. Default is 1.}

\item{res}{Numeric argument of length one, controls resolution of image.
Default is 100 (faster) although 300 - 400 is recommended for publication/
presentation quality.}

\item{flim}{A numeric vector of length two for the frequency limit in kHz of
the spectrogram, as in \code{\link[seewave]{spectro}}. Default is c(0, 22).}

\item{ls}{Logical argument. If TRUE long spectrograms (as in lspec function)
are produce.}

\item{sxrow}{A numeric vector of length one. Specifies seconds of spectrogram
per row when creating long spectrograms. Default is 10. Applied when is
TRUE and/or when X is not provided.}

\item{rows}{A numeric vector of length one. Specifies number of rows per
image file when creating long spectrograms. Default is 10. Applied when is
TRUE and/or when X is not provided.}

\item{mindur}{Numeric vector of length 1 giving the shortest duration (in
seconds) of the signals to be detected. It removes signals below that
threshold.}

\item{maxdur}{Numeric vector of length 1 giving the longest duration (in
seconds) of the signals to be detected. It removes signals above that
threshold.}

\item{redo}{Logical argument. If TRUE all selection will be analyzed again
when code is rerun. If FALSE only the selections that do not have a image
file in the working directory will be analyzed. Default is FALSE.}

\item{img}{Logical argument. If FALSE image files are not produce. Default TRUE.}

\item{it}{A character vector of length one giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}

\item{set}{A logical argument indicating wheter the settings of the autodetection
process should be included in the image file name. If TRUE threshold (th), envelope (envt), bandpass (bp), power (pw), msmooth (msmo),
maxdur (mxdu), and mindur (midu) are included.}

\item{flist}{character vector or factor indicating the subset of files that will be analyzed. Ignored
if X is provided.}
}
\value{
Spectrograms showing the start and end of the detected signals. It
  also returns a data frame containing the start and end of each signal by
  sound file and selection number.
}
\description{
Detects the start and end of vocalizations in sound files automatically based
on differences in amplitude.
}
\details{
This function determines the start and end of signals (hopefuly
  vocalizations) in the segments of the sound files listed in the input data
  frame. Alternatively, if no data frame is provided, the function creates long
  spectrograms for all sound files in the working directory.The ouptut of manualoc
  can be used as the input data frame. The input data frame should have the following
  columns: c("sound.files","selec","start","end","sel.comment"). This function uses
  internally a modified version of the \code{\link[seewave]{timer}} function from seewave
  package to detect signals.
}
\examples{
\dontrun{
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4"))
writeWave(Phae.long1,"Phae.long1.wav")
writeWave(Phae.long2,"Phae.long2.wav")
writeWave(Phae.long3,"Phae.long3.wav")
writeWave(Phae.long4,"Phae.long4.wav")

ad <- autodetec(threshold=5, env="hil", msmooth=c(900,90), power=1,
bp=c(2,9), xl = 2, picsize = 2, res = 200, flim= c(1,12), osci = TRUE,
wl = 300, ls = FALSE,  sxrow = 2, rows = 4, mindur=0.1, maxdur=1, set = T)

#run it with different settings
ad <- autodetec(threshold=10, env="abs", msmooth=c(900,90), power=1,
bp=c(2,9), xl = 2, picsize = 2, res = 200, flim= c(1,12), osci = TRUE,
wl = 300, ls = FALSE,  sxrow = 2, rows = 4, mindur=0.1, maxdur=1, set = T)

#check working directory
}
}
\author{
Marcelo Araya-Salas http://marceloarayasalas.weebly.com/
}

