% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.r
\name{magic_wand_file}
\alias{magic_wand_file}
\title{Use the "magic" file that comes with the package}
\usage{
magic_wand_file(refresh = FALSE)
}
\arguments{
\item{refresh}{ensure the lastest copy of the pacakge "magic"
database is used.}
}
\description{
The \code{magic_load()} functon from \code{libmagic} can't take ZIP files
and the \code{magic.mgc} file that ships with the package is too large to
be shipped uncompressed. Using this function as the \code{magic_db}
parameter will copy and uncompress the database to a cache directory and
return the full path to the magic file. Subsequent calls will not have to
perform the decompression unless \code{force} is \code{TRUE} or the
cache directory has been cleared.
}
\note{
'magic' files are highly coupled with the version of the \code{file}
  utility they were built with. This function is provided solely for the
  off chance that a macOS or Linux/UNIX system's \code{libmagic} library
  was not configured properly and cannot find the system 'magic' file.
}
\examples{
library(dplyr)

system.file("extdata/img", package="wand") \%>\%
  list.files(full.names=TRUE) \%>\%
  incant(magic_wand_file()) \%>\%
  glimpse()
}

