% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walrus.R
\docType{package}
\name{walrus-package}
\alias{walrus}
\alias{walrus-package}
\title{Walrus}
\description{
A toolbox of common robust statistical tests, including robust
descriptives, robust t-tests, and robust ANOVA. It is also available as a
module for 'jamovi' (see \href{https://www.jamovi.org}{www.jamovi.org} for
more information).
Walrus is based on the \code{WRS2} package by Patrick Mair, which is in turn based on
the scripts and work of Rand Wilcox. These analyses are described in depth in
the book \href{https://www.amazon.com/Introduction-Estimation-Hypothesis-Statistical-Modeling/dp/012804733X}{Introduction to Robust Estimation & Hypothesis Testing}.
}
\details{
\tabular{llllll}{
  Box & Violin Plots \tab \tab \tab \tab \code{\link{rplots}()} \cr
  Robust Descriptives \tab \tab \tab \tab \code{\link{rdesc}()} \cr
  Robust Independent Samples T-Test \tab \tab \tab \tab \code{\link{rttestIS}}() \cr
  Robust Paired Samples T-Test \tab \tab \tab \tab \code{\link{rttestIS}()} \cr
  Robust ANOVA \tab \tab \tab \tab \code{\link{ranova}()} \cr
}

\preformatted{
Ravi:
    "Should we create a logo for walrus?"

Jonathon:
    "Yeah, I guess. Maybe a walrus, or a
    skewed distribution?
    Bonus points if it somehow contains both."

Ravi gets bonus points

}

\if{html}{\figure{walrus.svg}{options: width=72px style="padding-left: 50px"}}
\if{latex}{\figure{walrus.pdf}{options: width=1in}}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/jamovi/walrus}
  \item Report bugs at \url{https://github.com/jamovi/walrus/issues}
}

}
