% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isochrone_pois.R
\name{isochrone_pois}
\alias{isochrone_pois}
\title{Issue a walkalytics isochrone query}
\usage{
isochrone_pois(x, y, epsg = 3857, max_min = 1000, pois,
  key = "my_walkalytics_key")
}
\arguments{
\item{x}{x-coordinate of the source location (coordinate system is WGS/84 Pseudo Mercator).}

\item{y}{y-coordinate of the source location (coordinate system is WGS/84 Pseudo Mercator).}

\item{epsg}{EPSG code for coordinate system of the x- and y-coordinate.}

\item{max_min}{maximum number of minutes for the isochrone.}

\item{pois}{a \code{data.frame} to specify a set of points-of-interest (POIs). The API calculates the duration
    time for walking from the source location to each POI. The following columns are required:
\itemize{
\item \code{x} x-coordinate of the source location (EPSG:3857).
\item \code{y} y-coordinate of the source location (EPSG:3857).
\item \code{id} name of POI (optional)
}}

\item{key}{your \code{walkalytics} subscription key which provides access to the API.}
}
\value{
The \link[httr]{response} object from the request. Use \link[walkalytics]{pois_walktimes}
    to directly extract the walking times between the source location and the points-of-interest.
}
\description{
\code{isochrone_pois} calls the \code{walkalytics} isochrone API which calculates the walking times from a source location
    and to a given set of points-of-interest (POIs).
}
\details{
To get an API key, you need to register at \url{https://dev.walkalytics.com/signin}.
    With the free starter account, you can make up to 100 calls a week to the API.
}
\examples{
\donttest{
# Generate set of POIs
x <- c(895777, 896044, 895639)
y <- c(6004833, 6004886, 6005147)
id <- c("pupil1", "pupil2", "pupil3")
pupils <- data.frame(x = x, y = y, id = id)

# Issue query
isochrone_pois(x = 895815, y = 6004839, pois = pupils, key = "abcd1234")
}
}
\references{
\href{https://dev.walkalytics.com/docs/services/}{Walkalytics API documentations}
}
