% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_wad.R
\name{read.quake1miptex}
\alias{read.quake1miptex}
\title{Read a Quake mipmap texture from a WAD2 file.}
\usage{
read.quake1miptex(filepath, at_offset = 0L)
}
\arguments{
\item{filepath}{character string, path to WAD file.}

\item{at_offset}{integer, the index in the WAD file where the texture starts.}
}
\value{
a 'qmiptex' instance, its like a wall with shorter name field (16 instead of 32) and some fields (anim_name, flags, contents, value) missing.
}
\description{
Read a Quake mipmap texture from a WAD2 file.
}
\examples{
\dontrun{
    qm = read.quake1miptex("~/knave.wad", at_offset = 1317632);
    plotwal.mipmap(qm, apply_palette = pal_q1());
}

}
