% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/height.R
\name{height}
\alias{height}
\alias{height_cm}
\alias{height_in}
\title{Generate Random Vector of Heights}
\usage{
height(n, mean = 69, sd = 3.75, min = 1, max = NULL, digits = 0,
  name = "Height")

height_in(n, mean = 69, sd = 3.75, min = 1, max = NULL, digits = 1,
  name = "Height(in)")

height_cm(n, mean = 175.26, sd = 9.525, min = 1, max = NULL,
  digits = 1, name = "Height(cm)")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{mean}{The mean value for the normal distribution to be drawn from.}

\item{sd}{The standard deviation of the normal distribution to draw from.}

\item{min}{A numeric lower boundary cutoff.  Results less than this value will be
replaced with \code{min}.}

\item{max}{A numeric upper boundary cutoff.  Results greater than this value will
be replaced with \code{max}.}

\item{digits}{Integer indicating the number of decimal places to be used.
Negative values are allowed (see \code{\link[base]{round}}).}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random normal vector of height elements.
}
\description{
\code{height} and \code{height_in} - Generate a random normal vector of
heights in inches.

\code{height_cm} - Generate a random normal vector of heights in centimeters.
}
\note{
\code{height} rounds to nearest whole number.  \code{height_in} &
\code{height_in} round to the nearest tenths.
}
\examples{
height(10)
hist(height(10000))
interval(height, 5, n = 1000)
}
\seealso{
Other variable.functions: \code{\link{age}},
  \code{\link{animal}}, \code{\link{answer}},
  \code{\link{area}}, \code{\link{car}},
  \code{\link{children}}, \code{\link{coin}},
  \code{\link{color}}, \code{\link{date_stamp}},
  \code{\link{death}}, \code{\link{dice}},
  \code{\link{dna}}, \code{\link{dob}},
  \code{\link{dummy}}, \code{\link{education}},
  \code{\link{employment}}, \code{\link{eye}},
  \code{\link{grade_level}}, \code{\link{grade}},
  \code{\link{group}}, \code{\link{hair}},
  \code{\link{income}}, \code{\link{internet_browser}},
  \code{\link{iq}}, \code{\link{language}},
  \code{\link{level}}, \code{\link{likert}},
  \code{\link{lorem_ipsum}}, \code{\link{marital}},
  \code{\link{military}}, \code{\link{month}},
  \code{\link{name}}, \code{\link{normal}},
  \code{\link{political}}, \code{\link{race}},
  \code{\link{religion}}, \code{\link{sat}},
  \code{\link{sentence}}, \code{\link{sex_inclusive}},
  \code{\link{sex}}, \code{\link{smokes}},
  \code{\link{speed}}, \code{\link{state}},
  \code{\link{string}}, \code{\link{upper}},
  \code{\link{valid}}, \code{\link{year}},
  \code{\link{zip_code}}
}
\keyword{height}

