% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/butler.R
\name{butler}
\alias{butler}
\alias{use_butler}
\alias{show_butler}
\alias{hide_butler}
\alias{config_butler}
\alias{Butler}
\title{Butler}
\usage{
use_butler()

show_butler()

hide_butler()

config_butler(
  thickness = 5,
  colors = list(`0` = "red", `.3` = "blue", `1` = "green"),
  shadow_blur = 5,
  shadow_color = "rgba(0, 0, 0, .5)"
)
}
\arguments{
\item{thickness}{Thickness of the bar.}

\item{colors}{List of gradient color stops used to draw the progress bar.}

\item{shadow_blur}{Shadow blur size.}

\item{shadow_color}{Shadow color.}
}
\description{
Programmatically show and hide loading bar.
}
\section{Functions}{

\itemize{
 \item{\code{use_butler}: butler dependencies to include anywhere in your UI but ideally at the top.}
 \item{\code{show_butler}: Show a butler.}
 \item{\code{hide_butler}: Hide butler.}
 \item{\code{config_butler}: Configure the butler.}
}
}

\section{Class}{

Arguments passed to \code{config_butler} are passed to the initialisation method \code{new}.
\itemize{
  \item{\code{Butler}: initiatlise a Butler.} 
}
}

\examples{
library(shiny)

ui <- fluidPage(
	use_butler(),
	br(),
	actionButton("show", "show butler"),
	actionButton("hide", "hide butler")
)

server <- function(input, output){

	observeEvent(input$show,{
		show_butler()
	})

	observeEvent(input$hide,{
		hide_butler()
	})

}

if(interactive()) shinyApp(ui, server)


## ------------------------------------------------
## Method `Butler$new`
## ------------------------------------------------

\dontrun{Butler$new()}

## ------------------------------------------------
## Method `Butler$show`
## ------------------------------------------------

\dontrun{Butler$new()$show()}

## ------------------------------------------------
## Method `Butler$hide`
## ------------------------------------------------

\dontrun{Butler$new()$show()$hide()}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Butler$new()}}
\item \href{#method-show}{\code{Butler$show()}}
\item \href{#method-hide}{\code{Butler$hide()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Butler$new(
  thickness = 5,
  colors = list(`0` = "red", `.3` = "blue", `1` = "green"),
  shadow_blur = 5,
  shadow_color = "rgba(0, 0, 0, .5)"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{thickness}}{Thickness of the bar.}

\item{\code{colors}}{List of gradient color stops used to draw the progress bar.}

\item{\code{shadow_blur}}{Shadow blur size.}

\item{\code{shadow_color}}{Shadow color.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create a butler.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Butler$new()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\subsection{Method \code{show()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Butler$show()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Show the butler.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Butler$new()$show()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hide"></a>}}
\subsection{Method \code{hide()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Butler$hide()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Hide the butler.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Butler$new()$show()$hide()}
}
\if{html}{\out{</div>}}

}

}
}
