% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{scale_color_wa_d}
\alias{scale_color_wa_d}
\alias{scale_fill_wa_d}
\alias{scale_color_wa_c}
\alias{scale_fill_wa_c}
\alias{scale_color_wa_b}
\alias{scale_fill_wa_b}
\alias{scale_colour_wa_d}
\alias{scale_colour_wa_c}
\alias{scale_colour_wa_b}
\title{Color palettes for \code{ggplot2}}
\usage{
scale_color_wa_d(palette = "rainier", which = NULL, ..., reverse = FALSE)

scale_fill_wa_d(palette = "rainier", which = NULL, ..., reverse = FALSE)

scale_color_wa_c(
  palette = "sound_sunset",
  which = NULL,
  midpoint = NULL,
  ...,
  reverse = FALSE
)

scale_fill_wa_c(
  palette = "sound_sunset",
  which = NULL,
  midpoint = NULL,
  ...,
  reverse = FALSE
)

scale_color_wa_b(palette = "sound_sunset", which = NULL, ..., reverse = FALSE)

scale_fill_wa_b(palette = "sound_sunset", which = NULL, ..., reverse = FALSE)

scale_colour_wa_d(palette = "rainier", which = NULL, ..., reverse = FALSE)

scale_colour_wa_c(
  palette = "sound_sunset",
  which = NULL,
  midpoint = NULL,
  ...,
  reverse = FALSE
)

scale_colour_wa_b(palette = "sound_sunset", which = NULL, ..., reverse = FALSE)
}
\arguments{
\item{palette}{a \code{\link{wacolors}} palette or palette name.}

\item{which}{if not \code{NULL}, the indices or names of a subset of colors to use.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}},
\code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}, or \code{\link[ggplot2:binned_scale]{ggplot2::binned_scale()}} to control
name, limits, breaks, labels and so forth.}

\item{reverse}{\code{TRUE} if the colors should be reversed.}

\item{midpoint}{if not \code{NULL} and at least one limit is not provided, the
value to center the scale at. Useful for diverging scales.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Scale} object.
}
\description{
Color palettes for \code{ggplot2}
}
\examples{
library(ggplot2)

ggplot(mtcars, aes(mpg, wt)) +
    geom_point(aes(color = factor(cyl), size=hp)) +
    scale_color_wa_d()

ggplot(mtcars, aes(mpg, wt)) +
    geom_point(aes(color = hp)) +
    scale_color_wa_c("palouse",  which=c("snake", "wheat"))

ggplot(diamonds) +
    geom_bar(aes(x = cut, fill = clarity)) +
    scale_fill_wa_d(wacolors$sound_sunset, reverse=TRUE)

}
