#' Visual Studio Projects
#'
#' @description
#' These functions will allow you to scrape project information from Visual Studio.
#'
#' @details
#' For more information about project API calls check
#' \url{https://docs.microsoft.com/en-us/rest/api/vsts/core/projects}.
#'
#' @param domain the location of the visual studio server
#' @param auth_key authentication key generated by using \code{\link{vsts_auth_key}}
#' @param quiet logical whether want general running information from printing. Any issue with the API call will
#' still show up if set to \code{TRUE}
#'
#' @rdname vsts_project
#' @export
vsts_get_projects <- function(domain, auth_key, quiet = FALSE) {
  uri <- paste0('https://', domain, '.visualstudio.com/_apis/projects?api-version=1.0')

  response <- httr::GET(uri, httr::add_headers(Authorization = auth_key))
  if(httr::status_code(response) != 200) {
    cat(httr::http_condition(response, 'message', 'get project list')$message, '\n')
    return(invisible(NULL))
  }

  content <- httr::content(response, as = 'text', encoding = 'UTF-8') %>% jsonlite::fromJSON(., flatten = TRUE) %>% .$value
  if(!quiet) cat('Available projects:', paste(content$name, collapse = ', '), '\n')
  return(invisible(content))
}
