% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vroom.R
\name{vroom}
\alias{vroom}
\title{Read a delimited file into a tibble}
\usage{
vroom(
  file,
  delim = NULL,
  col_names = TRUE,
  col_types = NULL,
  col_select = NULL,
  id = NULL,
  skip = 0,
  n_max = Inf,
  na = c("", "NA"),
  quote = "\\"",
  comment = "",
  trim_ws = TRUE,
  escape_double = TRUE,
  escape_backslash = FALSE,
  locale = default_locale(),
  guess_max = 100,
  altrep = TRUE,
  altrep_opts = deprecated(),
  num_threads = vroom_threads(),
  progress = vroom_progress(),
  .name_repair = "unique"
)
}
\arguments{
\item{file}{path to a local file.}

\item{delim}{One or more characters used to delimit fields within a
file. If \code{NULL} the delimiter is guessed from the set of \code{c(",", "\\t", " ", "|", ":", ";")}.}

\item{col_names}{Either \code{TRUE}, \code{FALSE} or a character vector
of column names.

If \code{TRUE}, the first row of the input will be used as the column
names, and will not be included in the data frame. If \code{FALSE}, column
names will be generated automatically: X1, X2, X3 etc.

If \code{col_names} is a character vector, the values will be used as the
names of the columns, and the first row of the input will be read into
the first row of the output data frame.

Missing (\code{NA}) column names will generate a warning, and be filled
in with dummy names \code{X1}, \code{X2} etc. Duplicate column names
will generate a warning and be made unique with a numeric prefix.}

\item{col_types}{One of \code{NULL}, a \code{\link[readr:cols]{cols()}} specification, or
a string. See \code{vignette("readr")} for more details.

If \code{NULL}, all column types will be imputed from the first 1000 rows
on the input. This is convenient (and fast), but not robust. If the
imputation fails, you'll need to supply the correct types yourself.

If a column specification created by \code{\link[readr:cols]{cols()}}, it must contain
one column specification for each column. If you only want to read a
subset of the columns, use \code{\link[readr:cols]{cols_only()}}.

Alternatively, you can use a compact string representation where each
character represents one column:
c = character, i = integer, n = number, d = double,
l = logical, f = factor, D = date, T = date time, t = time, ? = guess, or
\code{_}/\code{-} to skip the column.}

\item{col_select}{One or more selection expressions, like in
\code{dplyr::select()}. Use \code{c()} or \code{list()} to use more than one expression.
See \code{?dplyr::select} for details on available selection options.}

\item{id}{Either a string or 'NULL'. If a string, the output will contain a
variable with that name with the filename(s) as the value. If 'NULL', the
default, no variable will be created.}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Maximum number of records to read.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{quote}{Single character used to quote strings.}

\item{comment}{A string used to identify comments. Any text after the
comment characters will be silently ignored.}

\item{trim_ws}{Should leading and trailing whitespace be trimmed from
each field before parsing it?}

\item{escape_double}{Does the file escape quotes by doubling them?
i.e. If this option is \code{TRUE}, the value '""' represents
a single quote, '"'.}

\item{escape_backslash}{Does the file use backslashes to escape special
characters? This is more general than \code{escape_double} as backslashes
can be used to escape the delimiter character, the quote character, or
to add special characters like \code{\\n}.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[readr:locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{guess_max}{Maximum number of records to use for guessing column types.}

\item{altrep}{Control which column types use Altrep representations,
either a character vector of types, \code{TRUE} or \code{FALSE}. See
\code{\link[=vroom_altrep]{vroom_altrep()}} for for full details.}

\item{altrep_opts}{\Sexpr[results=rd, stage=render]{lifecycle::badge("deprecated")}}

\item{num_threads}{Number of threads to use when reading and materializing
vectors. If your data contains embedded newlines (newlines within fields)
you \emph{must} use \code{num_threads = 1} to read the data properly.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session and not while knitting a document. The display
is updated every 50,000 values and will only display if estimated reading
time is 5 seconds or more. The automatic progress bar can be disabled by
setting option \code{readr.show_progress} to \code{FALSE}.}

\item{.name_repair}{Handling of column names. By default, vroom ensures
column names are not empty and unique. See \code{.name_repair} as documented in
\code{\link[tibble:tibble]{tibble::tibble()}} for additional options including supplying user defined
name repair functions.}
}
\description{
Read a delimited file into a tibble
}
\examples{
# Show path to example file
input_file <- vroom_example("mtcars.csv")

# Read from a path

# Input sources -------------------------------------------------------------
# Read from a path
vroom(input_file)
# You can also use literal paths directly
# vroom("mtcars.csv")

\dontrun{
# Including remote paths
vroom("https://github.com/r-lib/vroom/raw/master/inst/extdata/mtcars.csv")
}

# Or directly from a string (must contain a trailing newline)
vroom("x,y\n1,2\n3,4\n")

# Column selection ----------------------------------------------------------
# Pass column names or indexes directly to select them
vroom(input_file, col_select = c(model, cyl, gear))
vroom(input_file, col_select = c(1, 3, 11))

# Or use the selection helpers
vroom(input_file, col_select = starts_with("d"))

# You can also rename specific columns
vroom(input_file, col_select = list(car = model, everything()))

# Column types --------------------------------------------------------------
# By default, vroom guesses the columns types, looking at 1000 rows
# throughout the dataset.
# You can specify them explcitly with a compact specification:
vroom("x,y\n1,2\n3,4\n", col_types = "dc")

# Or with a list of column types:
vroom("x,y\n1,2\n3,4\n", col_types = list(col_double(), col_character()))

# File types ----------------------------------------------------------------
# csv
vroom("a,b\n1.0,2.0\n", delim = ",")
# tsv
vroom("a\tb\n1.0\t2.0\n")
# Other delimiters
vroom("a|b\n1.0|2.0\n", delim = "|")
}
