% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anchor.R
\name{AnchorFree}
\alias{AnchorFree}
\title{Non-negative tri-factorization of co-occurence matrix using minimum volume approach.}
\usage{
AnchorFree(
  vol,
  n.comp = 3,
  init = NULL,
  init.type = "diag",
  n.iter = 30,
  err.cut = 1e-30,
  verbose = FALSE
)
}
\arguments{
\item{vol}{An output object of vol_preprocess(). The method factorizes co-occurence matrix \code{vol$P}.}

\item{n.comp}{An integer. Number of components to extract (by default 3). Defines number of columns in matrix \eqn{C}. (default=3)}

\item{init}{A numeric matrix. Initial matrix \code{M}. (default=3)}

\item{init.type}{A character. A strategy to randomly initialize matrix \code{M}. (default="diag") Options are to

1) generate diagonal unit matrix ("diag"),

2) use ICA solution as initialization ("ica", "ica.pos").

or sample entries from:

3) uniform distribution \code{[0,1]} ("unif.pos"),

4) unform distribution \code{[-1,1]},

5) uniform distribution \code{[0.9,1.1]} ("similar"),

6) normal distribution \code{N(0,1)}.}

\item{n.iter}{An integer. Number of iterations. (default=30)}

\item{err.cut}{A numeric. Relative error in determinant between iterations to stop algorithm (now is not used). (default=1e-30)}

\item{verbose}{A boolean. Print per-iteration information (default=FALSE)}
}
\value{
List of objects:

\code{C}, \code{E} Factorization matrices.

\code{Pest} Estimate of \code{vol$P} co-occurence matrix \eqn{Pest = C*E*t(C)}.

\code{M}, \code{detM} auxiliary matrix \code{M} and its determinant.

\code{init.type} type of initialization of matrix \code{M} that was used.
}
\description{
\code{AnchorFree} method tri-factorizes (co-occurence) matrix in a product  \eqn{P ~ C*E*t(C)} of non-negative matrices \eqn{C} and \eqn{E}
such that matrix \eqn{E} has mininum volume and columns of matrix \eqn{C} equal to 1.
}
\details{
Implementation closely follows (Fu X \emph{et al.}, IEEE Trans Pattern Anal Mach Intell., 2019).
}
\examples{
small_example <- sim_factors(5, 5, 5)
vol <- vol_preprocess(t(small_example$X))
vol.anchor <- AnchorFree(vol)

}
